/*
Navicat MySQL Data Transfer

Source Server         : dataWareHouse
Source Server Version : 50557
Source Host           : bi.ripit.cl:3306
Source Database       : biripit_dw_silob

Target Server Type    : MYSQL
Target Server Version : 50557
File Encoding         : 65001

Date: 2017-10-02 15:50:00
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for DW_analisis
-- ----------------------------
DROP TABLE IF EXISTS `DW_analisis`;
CREATE TABLE `DW_analisis` (
  `WID_analisis` int(11) NOT NULL AUTO_INCREMENT,
  `WID_resumen_mensual_ingreso` int(11) NOT NULL,
  `id_analisis` int(11) NOT NULL,
  `id_tipo_analisis` int(11) NOT NULL,
  `variacion` varchar(50) DEFAULT NULL,
  `id_muestra` int(11) DEFAULT NULL,
  `cod_norma_val` int(11) DEFAULT NULL,
  `cod_unidad` int(6) DEFAULT NULL,
  `cod_acreditacion` int(6) DEFAULT NULL,
  `id_envase` int(6) DEFAULT NULL,
  `id_set` int(11) DEFAULT NULL,
  `id_cartacontrol` int(11) DEFAULT NULL,
  `last_update` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`WID_analisis`),
  UNIQUE KEY `index_id_analisis` (`id_analisis`) USING BTREE,
  KEY `fk_analis_resum_ing` (`WID_resumen_mensual_ingreso`),
  CONSTRAINT `fk_analis_resum_ing` FOREIGN KEY (`WID_resumen_mensual_ingreso`) REFERENCES `DW_resumen_mensual_ingresos` (`WID_resumen_mensual_ingreso`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=211885 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_años
-- ----------------------------
DROP TABLE IF EXISTS `DW_años`;
CREATE TABLE `DW_años` (
  `WID_año` int(11) NOT NULL AUTO_INCREMENT,
  `año` int(4) NOT NULL,
  PRIMARY KEY (`WID_año`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_area
-- ----------------------------
DROP TABLE IF EXISTS `DW_area`;
CREATE TABLE `DW_area` (
  `WID_area` int(11) NOT NULL AUTO_INCREMENT,
  `id_area` int(11) NOT NULL,
  `area` varchar(100) NOT NULL,
  PRIMARY KEY (`WID_area`),
  UNIQUE KEY `index_id_area` (`id_area`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_clientes
-- ----------------------------
DROP TABLE IF EXISTS `DW_clientes`;
CREATE TABLE `DW_clientes` (
  `WID_cliente` int(11) NOT NULL AUTO_INCREMENT,
  `id_cliente` int(11) NOT NULL,
  `razon_social` varchar(1000) DEFAULT NULL,
  `nombre` varchar(1000) DEFAULT NULL,
  `nro_rut` int(9) DEFAULT NULL,
  `dv_rut` char(1) DEFAULT NULL,
  `direccion` varchar(500) DEFAULT NULL,
  `cont_facturacion` varchar(500) DEFAULT NULL,
  `fono_cont` varchar(25) DEFAULT NULL,
  `fono2_cont` varchar(25) DEFAULT NULL,
  `mail_cont` varchar(200) DEFAULT NULL,
  `cod_ciiu` int(11) DEFAULT NULL,
  `cod_status` int(11) DEFAULT NULL,
  `pub_local` tinyint(1) DEFAULT NULL,
  `pub_descrip` tinyint(1) DEFAULT NULL,
  `pub_fecham` tinyint(1) DEFAULT NULL,
  `estado_cl` enum('') DEFAULT NULL,
  `version` int(1) DEFAULT NULL,
  `flag_vigente` tinyint(1) DEFAULT NULL,
  `id_usuario_upin` int(11) DEFAULT NULL,
  `id_usuario_vali` int(11) DEFAULT NULL,
  `update_timestamp` timestamp NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `flag_eliminado` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`WID_cliente`),
  UNIQUE KEY `index_id_cliente` (`id_cliente`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=2157 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_encuestas
-- ----------------------------
DROP TABLE IF EXISTS `DW_encuestas`;
CREATE TABLE `DW_encuestas` (
  `WID_encuesta` int(11) NOT NULL,
  `WID_resumen_mensual_encuesta` int(11) NOT NULL,
  `id_encuesta` int(11) NOT NULL,
  `id_pregunta` int(11) NOT NULL,
  `valor_pregunta` tinyint(1) DEFAULT NULL,
  `id_contacto` int(11) DEFAULT NULL,
  `codigo` varchar(10) DEFAULT NULL,
  `fecha` datetime DEFAULT '0000-00-00 00:00:00',
  `area` char(1) DEFAULT NULL,
  `flag_muestreo` tinyint(1) DEFAULT NULL,
  `flag_analisis` tinyint(1) DEFAULT NULL,
  `mejora` text,
  `observacion` text,
  PRIMARY KEY (`WID_encuesta`),
  KEY `fk_res_enc_dw_enc` (`WID_resumen_mensual_encuesta`),
  CONSTRAINT `fk_res_enc_dw_enc` FOREIGN KEY (`WID_resumen_mensual_encuesta`) REFERENCES `DW_resumen_mensual_encuestas` (`WID_resumen_mensual_encuesta`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_fechas
-- ----------------------------
DROP TABLE IF EXISTS `DW_fechas`;
CREATE TABLE `DW_fechas` (
  `WID_fecha` int(11) NOT NULL AUTO_INCREMENT,
  `WID_año` int(4) NOT NULL,
  `WID_semestre` int(11) NOT NULL,
  `WID_mes` int(11) NOT NULL,
  `fecha` datetime NOT NULL,
  PRIMARY KEY (`WID_fecha`),
  KEY `fk_mes_fecha_1` (`WID_mes`),
  KEY `fk_anho_fecha_2` (`WID_año`),
  KEY `fk_sem_fecha_3` (`WID_semestre`),
  CONSTRAINT `fk_anho_fecha_2` FOREIGN KEY (`WID_año`) REFERENCES `DW_meses` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_mes_fecha_1` FOREIGN KEY (`WID_mes`) REFERENCES `DW_meses` (`WID_mes`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_sem_fecha_3` FOREIGN KEY (`WID_semestre`) REFERENCES `DW_meses` (`WID_semestre`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18629 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_indicadores
-- ----------------------------
DROP TABLE IF EXISTS `DW_indicadores`;
CREATE TABLE `DW_indicadores` (
  `WID_indicador` int(11) NOT NULL AUTO_INCREMENT,
  `WID_objetivo` int(11) NOT NULL,
  `WID_unidad` int(11) NOT NULL,
  `WID_proceso` int(11) NOT NULL,
  `indicador` varchar(40) NOT NULL,
  `frecuencia` varchar(20) NOT NULL,
  `manual` tinyint(1) NOT NULL,
  PRIMARY KEY (`WID_indicador`),
  KEY `WID_unidad` (`WID_unidad`),
  KEY `WID_proceso` (`WID_proceso`),
  KEY `WID_objetivo` (`WID_objetivo`),
  CONSTRAINT `fk_ind_proc` FOREIGN KEY (`WID_proceso`) REFERENCES `DW_unidades_por_proceso` (`WID_proceso`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_ind_obj` FOREIGN KEY (`WID_objetivo`) REFERENCES `DW_unidades_por_proceso` (`WID_objetivo`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_ind_uni` FOREIGN KEY (`WID_unidad`) REFERENCES `DW_unidades_por_proceso` (`WID_unidad`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Table structure for DW_ingresos
-- ----------------------------
DROP TABLE IF EXISTS `DW_ingresos`;
CREATE TABLE `DW_ingresos` (
  `WID_ingreso` int(11) NOT NULL AUTO_INCREMENT,
  `id_ingreso` int(11) NOT NULL,
  `id_tipo_ingreso` int(11) NOT NULL,
  `id_cliente` int(11) NOT NULL,
  `id_dependencia` int(11) NOT NULL,
  `id_usuario_ingreso` int(11) NOT NULL,
  `id_usuario_validacion` int(11) NOT NULL,
  `id_factura` int(11) NOT NULL,
  `nro_ingreso` varchar(100) NOT NULL,
  `raya` char(6) NOT NULL,
  `flag_reemplazado` char(1) NOT NULL,
  `flag_foto_informe` tinyint(1) NOT NULL,
  `flag_carta` tinyint(1) NOT NULL,
  `flag_sma` tinyint(1) NOT NULL,
  `titular_proyecto` varchar(300) NOT NULL,
  `rut_titular` varchar(200) NOT NULL,
  `representante` varchar(300) NOT NULL,
  `rut_representante` varchar(200) NOT NULL,
  `proyecto` varchar(200) NOT NULL,
  `instrumentos` varchar(200) NOT NULL,
  `muestreador` varchar(200) NOT NULL,
  `nro_requerimiento` varchar(100) NOT NULL,
  `fh_validacion` datetime NOT NULL,
  `fecha_ingreso` date NOT NULL,
  `hora_ingreso` time NOT NULL,
  `certificacion_snp` varchar(100) NOT NULL,
  `nro_formulario_snp` varchar(100) NOT NULL,
  `cod_destino_snp` varchar(5) NOT NULL,
  `cod_categoria` int(5) NOT NULL,
  `lugar_descarga` varchar(100) NOT NULL,
  `f_i_muestreo` date NOT NULL,
  `f_muestreo` date NOT NULL,
  `fh_almacenamiento` datetime NOT NULL,
  `h_i_muestreo` time NOT NULL,
  `h_t_muestreo` time NOT NULL,
  `f_i_verificacion` date NOT NULL,
  `f_t_verificacion` date NOT NULL,
  `cont_muestreo` varchar(500) NOT NULL,
  `nro_muestreo` varchar(30) NOT NULL,
  `id_muestreador` int(11) NOT NULL,
  `nro_muestreo2` int(20) NOT NULL,
  `id_muestreador2` int(11) NOT NULL,
  `cod_entrega` int(5) NOT NULL,
  `entidad_m` varchar(200) NOT NULL,
  `flag_limites` tinyint(1) NOT NULL,
  `lugar_muestreo` varchar(1000) NOT NULL,
  `envases_cliente` varchar(100) NOT NULL,
  `coleman_cliente` varchar(100) NOT NULL,
  `otros_bienes_cliente` varchar(500) NOT NULL,
  `fh_informe` datetime NOT NULL,
  `flag_caudal` char(1) NOT NULL,
  `flag_compuesta` char(1) NOT NULL,
  `fh_v_destino0` datetime NOT NULL,
  `fh_s_destino0` datetime NOT NULL,
  `cod_destino1` int(5) NOT NULL,
  `fh_i_destino1` datetime NOT NULL,
  `fh_s_destino1` datetime NOT NULL,
  `cod_destino2` int(5) NOT NULL,
  `fh_i_destino2` datetime NOT NULL,
  `fh_s_destino2` datetime NOT NULL,
  `cod_destino3` int(5) NOT NULL,
  `fh_i_destino3` datetime NOT NULL,
  `fh_s_destino3` datetime NOT NULL,
  `cod_destino4` int(5) NOT NULL,
  `fh_i_destino4` datetime NOT NULL,
  `fh_s_destino4` datetime NOT NULL,
  `cod_destino5` int(5) NOT NULL,
  `nro_fact` varchar(20) NOT NULL,
  `fh_fact` datetime NOT NULL,
  `monto_muestreo` int(13) NOT NULL,
  `monto_muestreo_oi` int(13) NOT NULL,
  `monto_analisis` int(13) NOT NULL,
  `flag_pagado` tinyint(1) NOT NULL,
  `nro_n_credito` varchar(20) NOT NULL,
  `monto_n_credito` int(13) NOT NULL,
  `file_cotizacion` varchar(200) NOT NULL,
  `transporte_envio1` int(5) NOT NULL,
  `nro_envio1` varchar(50) NOT NULL,
  `transporte_envio2` int(5) NOT NULL,
  `nro_envio2` varchar(50) NOT NULL,
  `persona_retira` varchar(100) NOT NULL,
  `contacto_retira` varchar(200) NOT NULL,
  `persona_recibe` varchar(100) NOT NULL,
  `contacto_recibe` varchar(200) NOT NULL,
  `fecha_recibe` date NOT NULL,
  `id_us_destino0` int(5) NOT NULL,
  `id_us_destino1` int(5) NOT NULL,
  `id_us_destino2` int(5) NOT NULL,
  `id_us_destino3` int(5) NOT NULL,
  `id_us_destino4` int(5) NOT NULL,
  `flag_infact` tinyint(1) NOT NULL,
  `file_recepcion` varchar(500) NOT NULL,
  `estado_caja` int(5) NOT NULL,
  `medio_transporte` int(5) NOT NULL,
  `comentarios` text NOT NULL,
  `cod_informe` int(5) NOT NULL,
  `flag_prioritario` char(1) NOT NULL,
  `abr` varchar(10) NOT NULL,
  `flag_estado` tinyint(1) NOT NULL,
  `flag_avisado` tinyint(1) NOT NULL,
  `cod_rechazo` int(11) NOT NULL,
  `file_acta` varchar(500) NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  `flag_aviso_fd` tinyint(1) NOT NULL,
  `flag_composito_lab` tinyint(1) NOT NULL,
  `fh_preparacion_c` datetime NOT NULL,
  `preparador` varchar(200) NOT NULL,
  `cantEnvases` int(5) NOT NULL,
  `nro_carpeta_snp` varchar(100) NOT NULL,
  `inspector_snp` varchar(100) NOT NULL,
  `f_envio_mts` date NOT NULL,
  `fecha_publicacion` datetime NOT NULL,
  PRIMARY KEY (`WID_ingreso`),
  UNIQUE KEY `index_id_ingreso` (`id_ingreso`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=9916 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_locales
-- ----------------------------
DROP TABLE IF EXISTS `DW_locales`;
CREATE TABLE `DW_locales` (
  `WID_local` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `WID_cliente` int(11) NOT NULL,
  `id_dependencia` int(11) NOT NULL,
  `id_cliente` int(11) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `direccion` varchar(500) NOT NULL,
  `gerencia` varchar(200) NOT NULL,
  `flag_activo` tinyint(1) NOT NULL,
  `version` int(6) NOT NULL,
  `estado_dep` enum('') NOT NULL,
  `id_usuario_upin` int(11) NOT NULL,
  `id_usuario_vali` int(11) NOT NULL,
  `fh_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`WID_local`),
  UNIQUE KEY `index_id_dependencia` (`id_dependencia`) USING BTREE,
  KEY `fk_local_clien` (`WID_cliente`),
  CONSTRAINT `fk_local_clien` FOREIGN KEY (`WID_cliente`) REFERENCES `DW_clientes` (`WID_cliente`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3085 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_meses
-- ----------------------------
DROP TABLE IF EXISTS `DW_meses`;
CREATE TABLE `DW_meses` (
  `WID_mes` int(11) NOT NULL AUTO_INCREMENT,
  `WID_año` int(4) NOT NULL,
  `WID_semestre` int(11) NOT NULL,
  `mes` int(11) NOT NULL,
  PRIMARY KEY (`WID_mes`),
  KEY `fk_año_semestre_mes` (`WID_año`),
  KEY `fk_sem_mes_1` (`WID_semestre`),
  CONSTRAINT `fk_año_semestre_mes` FOREIGN KEY (`WID_año`) REFERENCES `DW_semestres` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_sem_mes_1` FOREIGN KEY (`WID_semestre`) REFERENCES `DW_semestres` (`WID_semestre`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=613 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_metas_anuales
-- ----------------------------
DROP TABLE IF EXISTS `DW_metas_anuales`;
CREATE TABLE `DW_metas_anuales` (
  `WID_meta_anual` int(11) NOT NULL AUTO_INCREMENT,
  `WID_objetivo` int(11) NOT NULL,
  `WID_indicador` int(11) NOT NULL,
  `WID_unidad` int(11) NOT NULL,
  `WID_proceso` int(11) NOT NULL,
  `WID_año` int(11) NOT NULL,
  `valor_anual` double(11,3) NOT NULL,
  `meta_anual` double(11,3) NOT NULL,
  PRIMARY KEY (`WID_meta_anual`),
  KEY `fk_anho_obj` (`WID_objetivo`),
  KEY `fk_anho_indi` (`WID_indicador`),
  KEY `fk_anho_unid` (`WID_unidad`),
  KEY `fk_anho_proc` (`WID_proceso`),
  KEY `fk_anho_anho` (`WID_año`),
  CONSTRAINT `fk_anho_anho` FOREIGN KEY (`WID_año`) REFERENCES `DW_años` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_anho_indi` FOREIGN KEY (`WID_indicador`) REFERENCES `DW_indicadores` (`WID_indicador`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_anho_obj` FOREIGN KEY (`WID_objetivo`) REFERENCES `DW_indicadores` (`WID_objetivo`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_anho_proc` FOREIGN KEY (`WID_proceso`) REFERENCES `DW_indicadores` (`WID_proceso`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_anho_unid` FOREIGN KEY (`WID_unidad`) REFERENCES `DW_indicadores` (`WID_unidad`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_metas_semestrales
-- ----------------------------
DROP TABLE IF EXISTS `DW_metas_semestrales`;
CREATE TABLE `DW_metas_semestrales` (
  `WID_meta_semestre` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `WID_objetivo` int(11) NOT NULL,
  `WID_proceso` int(11) NOT NULL,
  `WID_unidad` int(11) NOT NULL,
  `WID_indicador` int(11) NOT NULL,
  `WID_año` int(11) NOT NULL,
  `WID_semestre` int(11) NOT NULL,
  `valor_semestral` double(11,3) NOT NULL,
  `meta_semestral` double(11,3) NOT NULL,
  PRIMARY KEY (`WID_meta_semestre`),
  KEY `fk_sem_obj` (`WID_objetivo`),
  KEY `fk_sem_indi` (`WID_indicador`),
  KEY `fk_sem_unid` (`WID_unidad`),
  KEY `fk_sem_proc` (`WID_proceso`),
  KEY `fk_sem_anho` (`WID_año`),
  KEY `fk_sem_sems` (`WID_semestre`),
  CONSTRAINT `fk_sem_sems` FOREIGN KEY (`WID_semestre`) REFERENCES `DW_semestres` (`semestre`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_sem_anho` FOREIGN KEY (`WID_año`) REFERENCES `DW_semestres` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_sem_indi` FOREIGN KEY (`WID_indicador`) REFERENCES `DW_indicadores` (`WID_indicador`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_sem_obj` FOREIGN KEY (`WID_objetivo`) REFERENCES `DW_indicadores` (`WID_objetivo`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_sem_proc` FOREIGN KEY (`WID_proceso`) REFERENCES `DW_indicadores` (`WID_proceso`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_sem_unid` FOREIGN KEY (`WID_unidad`) REFERENCES `DW_indicadores` (`WID_unidad`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Table structure for DW_muestras
-- ----------------------------
DROP TABLE IF EXISTS `DW_muestras`;
CREATE TABLE `DW_muestras` (
  `WID_muestra` int(11) NOT NULL AUTO_INCREMENT,
  `id_muestra` int(11) NOT NULL,
  `identificacion` int(11) NOT NULL,
  `duplicado` char(1) NOT NULL,
  `material_id` char(2) NOT NULL,
  `id_ingreso` int(11) NOT NULL,
  `id_tipo_muestra` int(11) NOT NULL,
  `clave` varchar(50) NOT NULL,
  `cod_submuestra` int(6) NOT NULL,
  `id_desc_prod` int(6) NOT NULL,
  `descripcion_muestra` varchar(500) NOT NULL,
  `cod_especie` int(6) NOT NULL,
  `t_ingreso` varchar(20) NOT NULL,
  `t_ingreso_error` varchar(5) NOT NULL,
  `t_corregida` varchar(5) NOT NULL,
  `id_termometro` int(6) NOT NULL,
  `vol_ingreso` varchar(7) NOT NULL,
  `ph_ingreso` decimal(5,0) NOT NULL,
  `flag_primario` char(1) NOT NULL,
  `flag_secundario` char(1) NOT NULL,
  `flag_refrigeracion` char(1) NOT NULL,
  `cant_refrigerante` int(3) NOT NULL,
  `flag_condicion` char(1) NOT NULL,
  `flag_identificacion` char(1) NOT NULL,
  `flag_testigo` char(1) NOT NULL,
  `flag_tmuestra` char(1) NOT NULL,
  `flag_nmuestras` char(1) NOT NULL,
  `flag_descripcion` char(1) NOT NULL,
  `flag_especie` char(1) NOT NULL,
  `flag_aceptado` char(1) NOT NULL,
  `estado_v` char(1) NOT NULL,
  `cod_val_resultados` int(6) NOT NULL,
  `n_muestras` int(3) NOT NULL,
  `obs_verificacion` varchar(5000) NOT NULL,
  `fh_verificacion` datetime NOT NULL,
  `idus_verificacion` int(11) NOT NULL,
  `foto` varchar(500) NOT NULL,
  `fecha_foto` varchar(500) NOT NULL,
  `hora_caudal` time NOT NULL,
  `caudal` varchar(20) NOT NULL,
  `formato_in` char(2) NOT NULL,
  `fecha_faena` varchar(50) NOT NULL,
  `fecha_elaboracion` varchar(100) NOT NULL,
  `fecha_vencimiento` varchar(50) NOT NULL,
  `temp_muestreo` varchar(10) NOT NULL,
  `frigorifico` varchar(200) NOT NULL,
  `cod_establecimiento` varchar(100) NOT NULL,
  `pais_origen` varchar(100) NOT NULL,
  `n_cortes` varchar(50) NOT NULL,
  `n_cajas` varchar(50) NOT NULL,
  `lote` varchar(100) NOT NULL,
  `datos_camion` varchar(100) NOT NULL,
  `flag_composito` char(1) NOT NULL,
  `contacto_manip` varchar(20) NOT NULL,
  `actividad_manip` varchar(200) NOT NULL,
  `seccion_manip` varchar(200) NOT NULL,
  `sala_manip` varchar(20) NOT NULL,
  `flag_cuadrante` char(1) NOT NULL,
  `cod_cuadrante` int(11) NOT NULL,
  `cod_regionh` int(6) NOT NULL,
  `cod_etapah` int(6) NOT NULL,
  `cod_consumoh` int(6) NOT NULL,
  `cod_tarroh` int(6) NOT NULL,
  `cod_peso_exph` int(6) NOT NULL,
  `cod_psmbh` int(6) NOT NULL,
  `cod_excepcionh` int(6) NOT NULL,
  `flag_acta` tinyint(1) NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`WID_muestra`),
  UNIQUE KEY `idex_id_muestra` (`id_muestra`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=79577 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_objetivos
-- ----------------------------
DROP TABLE IF EXISTS `DW_objetivos`;
CREATE TABLE `DW_objetivos` (
  `WID_objetivo` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(1000) NOT NULL,
  PRIMARY KEY (`WID_objetivo`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_preguntas
-- ----------------------------
DROP TABLE IF EXISTS `DW_preguntas`;
CREATE TABLE `DW_preguntas` (
  `WID_pregunta` int(11) NOT NULL,
  `id_pregunta` int(11) NOT NULL,
  `cod_encuesta` varchar(10) NOT NULL,
  `pregunta` varchar(255) NOT NULL,
  PRIMARY KEY (`WID_pregunta`),
  UNIQUE KEY `index_id_pregunta` (`id_pregunta`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_procesos
-- ----------------------------
DROP TABLE IF EXISTS `DW_procesos`;
CREATE TABLE `DW_procesos` (
  `WID_proceso` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(1000) NOT NULL,
  PRIMARY KEY (`WID_proceso`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_procesos_por_objetivo
-- ----------------------------
DROP TABLE IF EXISTS `DW_procesos_por_objetivo`;
CREATE TABLE `DW_procesos_por_objetivo` (
  `WID_proceso` int(11) NOT NULL,
  `WID_objetivo` int(11) NOT NULL,
  KEY `ind_pxo_obj` (`WID_objetivo`) USING BTREE,
  KEY `ind_pxo_proc` (`WID_proceso`) USING BTREE,
  CONSTRAINT `fk_pxo_proc` FOREIGN KEY (`WID_proceso`) REFERENCES `DW_procesos` (`WID_proceso`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_pxo_obj` FOREIGN KEY (`WID_objetivo`) REFERENCES `DW_objetivos` (`WID_objetivo`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_reclamos
-- ----------------------------
DROP TABLE IF EXISTS `DW_reclamos`;
CREATE TABLE `DW_reclamos` (
  `WID_reclamo` int(11) NOT NULL AUTO_INCREMENT,
  `WID_resumen_mensual_reclamo` int(11) NOT NULL,
  `id_reclamo` int(11) NOT NULL,
  `id_contacto_tecnico` int(11) NOT NULL,
  `ext_nombre` varchar(100) NOT NULL,
  `ext_mail` varchar(100) NOT NULL,
  `deteccion` enum('') NOT NULL,
  `area` varchar(500) NOT NULL,
  `descripcion` text NOT NULL,
  `id_ingreso_implicado` int(11) NOT NULL,
  `fh_abierto` datetime NOT NULL,
  `fh_cierre` date NOT NULL,
  `flag_aviso_cl` tinyint(1) NOT NULL,
  `flag_justificado` tinyint(1) NOT NULL,
  `justificacion` text NOT NULL,
  `flag_implicancias` tinyint(1) NOT NULL,
  `fecha_tnc` date NOT NULL,
  `just_implicancia` text NOT NULL,
  `flag_ea` tinyint(1) NOT NULL,
  `flag_oi` tinyint(1) NOT NULL,
  `fecha_aviso_oi` date NOT NULL,
  `id_ingreso_corregido` int(11) NOT NULL,
  `fecha_carta` date NOT NULL,
  `fecha_mail` date NOT NULL,
  `participantes` text NOT NULL,
  `estado` char(1) NOT NULL,
  `observaciones` text NOT NULL,
  `flag_eliminado` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`WID_reclamo`),
  UNIQUE KEY `index_id_reclamo` (`id_reclamo`) USING BTREE,
  KEY `fk_res_rec_dw_rec` (`WID_resumen_mensual_reclamo`),
  CONSTRAINT `fk_res_rec_dw_rec` FOREIGN KEY (`WID_resumen_mensual_reclamo`) REFERENCES `DW_resumen_mensual_reclamos` (`WID_resumen_mensual_reclamo`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_resumen_mensual_encuestas
-- ----------------------------
DROP TABLE IF EXISTS `DW_resumen_mensual_encuestas`;
CREATE TABLE `DW_resumen_mensual_encuestas` (
  `WID_resumen_mensual_encuesta` int(11) NOT NULL,
  `WID_mes` int(11) NOT NULL,
  `WID_pregunta` int(11) NOT NULL,
  `suma_general` decimal(10,0) DEFAULT NULL,
  `cant_clien_respond` int(11) DEFAULT NULL,
  PRIMARY KEY (`WID_resumen_mensual_encuesta`),
  KEY `fk_resum_mes_enc` (`WID_mes`),
  CONSTRAINT `fk_resum_mes_enc` FOREIGN KEY (`WID_mes`) REFERENCES `DW_meses` (`WID_mes`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_resumen_mensual_ingresos
-- ----------------------------
DROP TABLE IF EXISTS `DW_resumen_mensual_ingresos`;
CREATE TABLE `DW_resumen_mensual_ingresos` (
  `WID_resumen_mensual_ingreso` int(11) NOT NULL,
  `WID_año` int(4) NOT NULL,
  `WID_semestre` int(11) NOT NULL,
  `WID_mes` int(11) NOT NULL,
  `WID_tipo_ingreso` int(11) NOT NULL,
  `WID_tipo_muestra` int(11) NOT NULL,
  `WID_tipo_analisis` int(11) NOT NULL,
  `cant_ingresos` int(11) NOT NULL,
  `cant_analisis` int(11) NOT NULL,
  `cant_muestras` int(11) NOT NULL,
  `cant_informes` int(11) NOT NULL,
  `cant_infor_corr` int(11) NOT NULL,
  `cant_ingresos_mensual` int(11) NOT NULL,
  `cant_analisis_mensual` int(11) NOT NULL,
  `cant_muestras_mensual` int(11) NOT NULL,
  `cant_informes_mensual` int(11) NOT NULL,
  `cant_infor_corr_mensual` int(11) NOT NULL,
  PRIMARY KEY (`WID_resumen_mensual_ingreso`),
  KEY `fk_resum_ing_wid_año` (`WID_año`),
  KEY `fk_resum_inf_wid_sem` (`WID_semestre`),
  KEY `fk_resum_inf_wid_mes` (`WID_mes`),
  KEY `fk_resum_ing_wid_ting` (`WID_tipo_ingreso`),
  KEY `fk_resum_ing_wid_tmues` (`WID_tipo_muestra`),
  KEY `fk_resum_ing_wid_tanali` (`WID_tipo_analisis`),
  CONSTRAINT `fk_resum_inf_wid_sem` FOREIGN KEY (`WID_semestre`) REFERENCES `DW_meses` (`WID_semestre`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_resum_ing_wid_año` FOREIGN KEY (`WID_año`) REFERENCES `DW_meses` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_resum_ing_wid_tanali` FOREIGN KEY (`WID_tipo_analisis`) REFERENCES `DW_tipos_analisis` (`WID_tipo_analisis`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_resum_ing_wid_ting` FOREIGN KEY (`WID_tipo_ingreso`) REFERENCES `DW_tipos_ingresos` (`WID_tipo_ingreso`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_resum_ing_wid_tmues` FOREIGN KEY (`WID_tipo_muestra`) REFERENCES `DW_tipos_muestras` (`WID_tipo_muestra`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_resumen_mensual_reclamos
-- ----------------------------
DROP TABLE IF EXISTS `DW_resumen_mensual_reclamos`;
CREATE TABLE `DW_resumen_mensual_reclamos` (
  `WID_resumen_mensual_reclamo` int(11) NOT NULL,
  `WID_año` int(11) NOT NULL,
  `WID_mes` int(11) NOT NULL,
  `WID_area` int(11) NOT NULL,
  `cant_reclamos` int(11) NOT NULL,
  `cant_reclamosOI` int(11) NOT NULL,
  `cant_trab_realiz` int(11) NOT NULL,
  `cant_reclamos_mensual` int(11) NOT NULL,
  `cant_reclamosOI_mensual` int(11) NOT NULL,
  `cant_trab_realiz_mensual` int(11) NOT NULL,
  PRIMARY KEY (`WID_resumen_mensual_reclamo`),
  KEY `fk_anho_res_rec` (`WID_año`),
  KEY `fk_mes_res_rec` (`WID_mes`),
  KEY `fk_area_res_rec` (`WID_area`),
  CONSTRAINT `fk_anho_res_rec` FOREIGN KEY (`WID_año`) REFERENCES `DW_meses` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_area_res_rec` FOREIGN KEY (`WID_area`) REFERENCES `DW_area` (`WID_area`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_mes_res_rec` FOREIGN KEY (`WID_mes`) REFERENCES `DW_meses` (`WID_mes`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_semestres
-- ----------------------------
DROP TABLE IF EXISTS `DW_semestres`;
CREATE TABLE `DW_semestres` (
  `WID_semestre` int(11) NOT NULL AUTO_INCREMENT,
  `WID_año` int(4) NOT NULL,
  `semestre` int(11) NOT NULL,
  PRIMARY KEY (`WID_semestre`),
  KEY `fk_anho_semestre_1` (`WID_año`),
  KEY `semestre` (`semestre`),
  CONSTRAINT `fk_anho_semestre_1` FOREIGN KEY (`WID_año`) REFERENCES `DW_años` (`WID_año`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_tipos_analisis
-- ----------------------------
DROP TABLE IF EXISTS `DW_tipos_analisis`;
CREATE TABLE `DW_tipos_analisis` (
  `WID_tipo_analisis` int(11) NOT NULL AUTO_INCREMENT,
  `id_tipo_analisis` int(11) NOT NULL,
  `id_ta_padre` int(11) NOT NULL,
  `version` int(3) NOT NULL,
  `id_tipo_ingreso` int(11) NOT NULL,
  `id_tipo_muestra` int(11) NOT NULL,
  `id_envase` int(11) NOT NULL,
  `cod_area` int(6) NOT NULL,
  `nombre` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `cod_tecnica` int(6) NOT NULL,
  `cod_acreditacion` varchar(1000) NOT NULL,
  `norma` varchar(1000) NOT NULL,
  `tiempo_max` varchar(10) NOT NULL,
  `vol_muestra` varchar(50) NOT NULL,
  `cod_unidad` int(6) NOT NULL,
  `lim_deteccion` varchar(100) NOT NULL,
  `lim_cuantificacion` varchar(100) NOT NULL,
  `flag_vigente` tinyint(1) NOT NULL,
  `acred_muestreo` int(11) NOT NULL,
  `flag_cartacontrol` tinyint(1) NOT NULL,
  `id_usuario_upin` int(6) NOT NULL,
  `id_usuario_vali` int(6) NOT NULL,
  `flag_eliminado` tinyint(1) NOT NULL,
  `id_usuario_elim` int(6) NOT NULL,
  `id_usuario_conf` int(6) NOT NULL,
  `estado` char(1) NOT NULL,
  `update_timestamp` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`WID_tipo_analisis`),
  UNIQUE KEY `index_id_tAnalisis` (`id_tipo_analisis`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=8804 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_tipos_ingresos
-- ----------------------------
DROP TABLE IF EXISTS `DW_tipos_ingresos`;
CREATE TABLE `DW_tipos_ingresos` (
  `WID_tipo_ingreso` int(11) NOT NULL AUTO_INCREMENT,
  `id_tipo_ingreso` int(11) NOT NULL,
  `descripcion` varchar(100) NOT NULL,
  `obs` varchar(100) NOT NULL,
  PRIMARY KEY (`WID_tipo_ingreso`),
  UNIQUE KEY `index_id_tIngreso` (`id_tipo_ingreso`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_tipos_muestras
-- ----------------------------
DROP TABLE IF EXISTS `DW_tipos_muestras`;
CREATE TABLE `DW_tipos_muestras` (
  `WID_tipo_muestra` int(11) NOT NULL AUTO_INCREMENT,
  `id_tipo_muestra` int(11) NOT NULL,
  `id_tipo_ingreso` int(11) NOT NULL,
  `item` varchar(50) NOT NULL,
  `ABR` char(3) NOT NULL,
  `descripcion` varchar(1000) NOT NULL,
  `matriz` int(6) NOT NULL,
  `des_primario` varchar(1000) NOT NULL,
  `des_secundario` varchar(1000) NOT NULL,
  `des_refrigeracion` varchar(1000) NOT NULL,
  `cant_refrigerante` varchar(50) NOT NULL,
  `des_condicion` varchar(1000) NOT NULL,
  `des_identificacion` varchar(1000) NOT NULL,
  `des_ttraslado` varchar(1000) NOT NULL,
  `des_temperatura` varchar(1000) NOT NULL,
  `des_testigo` varchar(1000) NOT NULL,
  `obs` varchar(100) NOT NULL,
  `flag_activo` tinyint(1) NOT NULL,
  `estado_materia` enum('') NOT NULL,
  PRIMARY KEY (`WID_tipo_muestra`),
  UNIQUE KEY `index_id_tMuestra` (`id_tipo_muestra`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=437 DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_unidades
-- ----------------------------
DROP TABLE IF EXISTS `DW_unidades`;
CREATE TABLE `DW_unidades` (
  `WID_unidad` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`WID_unidad`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- ----------------------------
-- Table structure for DW_unidades_por_proceso
-- ----------------------------
DROP TABLE IF EXISTS `DW_unidades_por_proceso`;
CREATE TABLE `DW_unidades_por_proceso` (
  `WID_unidad` int(11) NOT NULL,
  `WID_objetivo` int(11) NOT NULL,
  `WID_proceso` int(11) NOT NULL,
  KEY `WID_objetivo` (`WID_objetivo`),
  KEY `WID_proceso` (`WID_proceso`),
  KEY `WID_unidad` (`WID_unidad`) USING BTREE,
  CONSTRAINT `fk_uxp_proc` FOREIGN KEY (`WID_proceso`) REFERENCES `DW_procesos_por_objetivo` (`WID_proceso`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_uxp_obj` FOREIGN KEY (`WID_objetivo`) REFERENCES `DW_procesos_por_objetivo` (`WID_objetivo`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_uxp_unid` FOREIGN KEY (`WID_unidad`) REFERENCES `DW_unidades` (`WID_unidad`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- ----------------------------
-- Procedure structure for insDimAreas_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimAreas_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimAreas_DW`()
BEGIN
INSERT INTO DW_area(WID_area,id_area,area) 
SELECT ar.WID_area,ar.id_area,ar.area
FROM biripit_pre_dw_silob.PDW_area ar 
WHERE ar.flag_insert IS NOT NULL
	ON DUPLICATE KEY UPDATE
id_area = ar.id_area,
area = ar.area;
UPDATE biripit_pre_dw_silob.PDW_area ar SET ar.flag_insert = null;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimCliente_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimCliente_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimCliente_DW`()
BEGIN
	SET foreign_key_checks = 0;
INSERT INTO DW_clientes(WID_cliente,id_cliente,razon_social,nombre,nro_rut,dv_rut,direccion,cont_facturacion,fono_cont,
fono2_cont,mail_cont,cod_ciiu,cod_status,pub_local,pub_descrip,pub_fecham,estado_cl,version,flag_vigente,id_usuario_upin,
id_usuario_vali,update_timestamp,flag_eliminado) 
SELECT 
cl.WID_cliente,cl.id_cliente,cl.razon_social,cl.nombre,cl.nro_rut,cl.dv_rut,cl.direccion,cl.cont_facturacion,cl.fono_cont,
cl.fono2_cont,cl.mail_cont,cl.cod_ciiu,cl.cod_status,cl.pub_local,cl.pub_descrip,cl.pub_fecham,cl.estado_cl,
cl.version,cl.flag_vigente,cl.id_usuario_upin,cl.id_usuario_vali,cl.update_timestamp,cl.flag_eliminado
FROM biripit_pre_dw_silob.PDW_clientes cl
ON DUPLICATE KEY UPDATE 
id_cliente=cl.id_cliente,
razon_social=cl.razon_social,
nombre=cl.nombre,
nro_rut=cl.nro_rut,
dv_rut=cl.dv_rut,
direccion=cl.direccion,
cont_facturacion=cl.cont_facturacion,
fono_cont=cl.fono_cont,
fono2_cont=cl.fono2_cont,
mail_cont=cl.mail_cont,
cod_ciiu=cl.cod_ciiu,
cod_status=cl.cod_status,
pub_local=cl.pub_local,
pub_descrip=cl.pub_descrip,
pub_fecham=cl.pub_fecham,
estado_cl=cl.estado_cl,
version=cl.version,
flag_vigente=cl.flag_vigente,
id_usuario_upin=cl.id_usuario_upin,
id_usuario_vali=cl.id_usuario_vali,
update_timestamp=cl.update_timestamp,
flag_eliminado=cl.flag_eliminado;
SET foreign_key_checks = 1;
UPDATE biripit_pre_dw_silob.PDW_clientes cl SET cl.flag_insert=null;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimLocales_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimLocales_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimLocales_DW`()
BEGIN
SET foreign_key_checks = 0;
INSERT INTO DW_locales (WID_local,WID_cliente,id_dependencia,id_cliente,nombre,direccion,gerencia,flag_activo,
version,estado_dep,id_usuario_upin,id_usuario_vali,fh_update)
SELECT 
dep.WID_local,dep.WID_cliente,dep.id_dependencia,dep.id_cliente,dep.nombre,dep.direccion,dep.gerencia,dep.flag_activo,
dep.version,dep.estado_dep,dep.id_usuario_upin,dep.id_usuario_vali,dep.fh_update
FROM biripit_pre_dw_silob.PDW_locales dep
WHERE dep.flag_insert IS NOT NULL
ON DUPLICATE KEY UPDATE
id_dependencia = dep.id_dependencia,
id_cliente = dep.id_cliente,
nombre = dep.nombre,
direccion = dep.direccion,
gerencia = dep.gerencia,
flag_activo = dep.flag_activo,
version = dep.version,
estado_dep = dep.estado_dep,
id_usuario_upin = dep.id_usuario_upin,
id_usuario_vali = dep.id_usuario_vali,
fh_update = dep.fh_update;
SET foreign_key_checks = 1;
UPDATE biripit_pre_dw_silob.PDW_locales dep SET dep.flag_insert=null;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimPreguntas_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimPreguntas_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimPreguntas_DW`()
BEGIN
SET foreign_key_checks = 0;
INSERT INTO DW_preguntas(
WID_pregunta,
id_pregunta,
cod_encuesta,
pregunta
) 
	SELECT 
preg.WID_pregunta,
preg.id_pregunta,
preg.cod_encuesta,
preg.pregunta
FROM biripit_pre_dw_silob.PDW_preguntas preg 
WHERE preg.flag_insert IS NOT NULL
	ON DUPLICATE KEY UPDATE
id_pregunta =	preg.id_pregunta,
cod_encuesta =	preg.cod_encuesta,
pregunta =	preg.pregunta;
UPDATE biripit_pre_dw_silob.PDW_preguntas preg SET preg.flag_insert = null;
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimTipos_analisis_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimTipos_analisis_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimTipos_analisis_DW`()
BEGIN
	SET foreign_key_checks = 0;
INSERT INTO DW_tipos_analisis(WID_tipo_analisis,id_tipo_analisis,id_ta_padre,version,id_tipo_ingreso,id_tipo_muestra,id_envase,
cod_area,nombre,name,cod_tecnica,cod_acreditacion,norma,tiempo_max,vol_muestra,cod_unidad,lim_deteccion,lim_cuantificacion,
flag_vigente,acred_muestreo,flag_cartacontrol,id_usuario_upin,id_usuario_vali,flag_eliminado,id_usuario_elim,id_usuario_conf,
estado,update_timestamp) 
SELECT 
ta.WID_tipo_analisis,ta.id_tipo_analisis,ta.id_ta_padre,ta.version,ta.id_tipo_ingreso,ta.id_tipo_muestra,
ta.id_envase,ta.cod_area,ta.nombre,ta.name,ta.cod_tecnica,ta.cod_acreditacion,ta.norma,ta.tiempo_max,ta.vol_muestra,
ta.cod_unidad,ta.lim_deteccion,ta.lim_cuantificacion,ta.flag_vigente,ta.acred_muestreo,ta.flag_cartacontrol,
ta.id_usuario_upin,ta.id_usuario_vali,ta.flag_eliminado,ta.id_usuario_elim,ta.id_usuario_conf,ta.estado,ta.update_timestamp
FROM biripit_pre_dw_silob.PDW_tipos_analisis ta 
ON DUPLICATE KEY UPDATE
id_tipo_analisis=ta.id_tipo_analisis ,
id_ta_padre=ta.id_ta_padre,
version=ta.version,
id_tipo_ingreso=ta.id_tipo_ingreso,
id_tipo_muestra=ta.id_tipo_muestra,
id_envase=ta.id_envase,
cod_area=ta.cod_area,
nombre=ta.nombre,
name=ta.name,
cod_tecnica=ta.cod_tecnica,
cod_acreditacion=ta.cod_acreditacion,
norma=ta.norma,
tiempo_max=ta.tiempo_max,
vol_muestra=ta.vol_muestra,
cod_unidad=ta.cod_unidad,
lim_deteccion=ta.lim_deteccion,
lim_cuantificacion=ta.lim_cuantificacion,
flag_vigente=ta.flag_vigente,
acred_muestreo=ta.acred_muestreo,
flag_cartacontrol=ta.flag_cartacontrol,
id_usuario_upin=ta.id_usuario_upin,
id_usuario_vali=ta.id_usuario_vali,
flag_eliminado=ta.flag_eliminado,
id_usuario_elim=ta.id_usuario_elim,
id_usuario_conf=ta.id_usuario_conf,
estado=ta.estado,
update_timestamp=ta.update_timestamp;
SET foreign_key_checks = 1;
UPDATE biripit_pre_dw_silob.PDW_tipos_analisis ta SET ta.flag_insert=null;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimTipos_ingresos_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimTipos_ingresos_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimTipos_ingresos_DW`()
BEGIN
INSERT INTO DW_tipos_ingresos(WID_tipo_ingreso,id_tipo_ingreso,descripcion,obs) 
	SELECT tp.WID_tipo_ingreso,tp.id_tipo_ingreso,tp.descripcion,tp.obs 
FROM biripit_pre_dw_silob.PDW_tipos_ingresos tp 
WHERE tp.flag_insert IS NOT NULL
	ON DUPLICATE KEY UPDATE
	id_tipo_ingreso=tp.id_tipo_ingreso,
	descripcion=tp.descripcion,
	obs=tp.obs;
UPDATE biripit_pre_dw_silob.PDW_tipos_ingresos tp SET tp.flag_insert = null;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insDimTipos_muestras_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insDimTipos_muestras_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insDimTipos_muestras_DW`()
BEGIN
	SET foreign_key_checks = 0;
INSERT INTO DW_tipos_muestras (WID_tipo_muestra,id_tipo_muestra,id_tipo_ingreso,item,ABR,descripcion,matriz,des_primario,
des_secundario,des_refrigeracion,cant_refrigerante,des_condicion,des_identificacion,des_ttraslado,des_temperatura,
des_testigo,obs,flag_activo,estado_materia)
SELECT 
tm.WID_tipo_muestra,tm.id_tipo_muestra,tm.id_tipo_ingreso,tm.item,tm.ABR,tm.descripcion,tm.matriz,tm.des_primario,tm.des_secundario,
tm.des_refrigeracion,tm.cant_refrigerante,tm.des_condicion,tm.des_identificacion,tm.des_ttraslado,tm.des_temperatura,
tm.des_testigo,tm.obs,tm.flag_activo,tm.estado_materia
FROM biripit_pre_dw_silob.PDW_tipos_muestras tm 
ON DUPLICATE KEY UPDATE
id_tipo_muestra = tm.id_tipo_muestra,
id_tipo_ingreso = tm.id_tipo_ingreso,
item = tm.item,
ABR = tm.ABR,
descripcion = tm.descripcion,
matriz = tm.matriz,
des_primario = tm.des_primario,
des_secundario = tm.des_secundario,
des_refrigeracion = tm.des_refrigeracion,
cant_refrigerante = tm.cant_refrigerante,
des_condicion = tm.des_condicion,
des_identificacion = tm.des_identificacion,
des_ttraslado = tm.des_ttraslado,
des_temperatura = tm.des_temperatura,
des_testigo = tm.des_testigo,
obs = tm.obs,
flag_activo = tm.flag_activo,
estado_materia = tm.estado_materia;
SET foreign_key_checks = 0;
UPDATE biripit_pre_dw_silob.PDW_tipos_muestras tm SET tm.flag_insert=null;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insResEncuestas_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insResEncuestas_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insResEncuestas_DW`()
BEGIN
SET foreign_key_checks = 0;
INSERT INTO DW_resumen_mensual_encuestas (
WID_resumen_mensual_encuesta,
WID_mes,
WID_pregunta,
suma_general,
cant_clien_respond
)
SELECT 
Rencu.WID_resumen_mensual_encuesta,
Rencu.WID_mes,
Rencu.WID_pregunta,
Rencu.suma_general,
Rencu.cant_clien_respond
FROM biripit_pre_dw_silob.PDW_resumen_mensual_encuestas Rencu
WHERE Rencu.flag_insert IS NOT NULL
ON DUPLICATE KEY UPDATE
WID_mes = Rencu.WID_mes,
WID_pregunta = Rencu.WID_pregunta,
suma_general = Rencu.suma_general,
cant_clien_respond = Rencu.cant_clien_respond;
SET foreign_key_checks = 1;
UPDATE biripit_pre_dw_silob.PDW_resumen_mensual_encuestas Rencu SET Rencu.flag_insert=null;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insResIngresos_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insResIngresos_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insResIngresos_DW`()
BEGIN
	SET foreign_key_checks = 0;
INSERT INTO DW_resumen_mensual_ingresos (
WID_resumen_mensual_ingreso,
WID_año,
WID_semestre,
WID_mes,
WID_tipo_ingreso,
WID_tipo_muestra,
WID_tipo_analisis,
cant_ingresos,
cant_analisis,
cant_muestras,
cant_informes,
cant_infor_corr,
cant_ingresos_mensual,
cant_analisis_mensual,
cant_muestras_mensual,
cant_informes_mensual,
cant_infor_corr_mensual
)
SELECT 
rIng.WID_resumen_mensual_ingreso,
rIng.WID_año,
rIng.WID_semestre,
rIng.WID_mes,
rIng.WID_tipo_ingreso,
rIng.WID_tipo_muestra,
rIng.WID_tipo_analisis,
rIng.cant_ingresos,
rIng.cant_analisis,
rIng.cant_muestras,
rIng.cant_informes,
rIng.cant_infor_corr,
rIng.cant_ingresos_mensual,
rIng.cant_analisis_mensual,
rIng.cant_muestras_mensual,
rIng.cant_informes_mensual,
rIng.cant_infor_corr_mensual
FROM biripit_pre_dw_silob.PDW_resumen_mensual_ingresos rIng
WHERE rIng.flag_insert IS NOT NULL
ON DUPLICATE KEY UPDATE
WID_año = rIng.WID_año,
WID_semestre = rIng.WID_semestre,
WID_mes = rIng.WID_mes,
WID_tipo_ingreso = rIng.WID_tipo_ingreso,
WID_tipo_muestra = rIng.WID_tipo_muestra,
WID_tipo_analisis = rIng.WID_tipo_analisis,
cant_ingresos = rIng.cant_ingresos,
cant_analisis = rIng.cant_analisis,
cant_muestras = rIng.cant_muestras,
cant_informes = rIng.cant_informes,
cant_infor_corr = rIng.cant_infor_corr,
cant_ingresos_mensual = rIng.cant_ingresos_mensual,
cant_analisis_mensual = rIng.cant_analisis_mensual,
cant_muestras_mensual = rIng.cant_muestras_mensual,
cant_informes_mensual = rIng.cant_informes_mensual,
cant_infor_corr_mensual = rIng.cant_infor_corr_mensual;
SET foreign_key_checks = 1;
UPDATE biripit_pre_dw_silob.PDW_resumen_mensual_ingresos rIng SET rIng.flag_insert=null;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insResReclamos_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insResReclamos_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insResReclamos_DW`()
BEGIN
SET foreign_key_checks = 0;
INSERT INTO DW_resumen_mensual_reclamos (
WID_resumen_mensual_reclamo,
WID_año,
WID_mes,
WID_area,
cant_reclamos,
cant_reclamosOI,
cant_trab_realiz,
cant_reclamos_mensual,
cant_reclamosOI_mensual,
cant_trab_realiz_mensual
)
SELECT 
rRec.WID_resumen_mensual_reclamo,
rRec.WID_año,
rRec.WID_mes,
rRec.WID_area,
rRec.cant_reclamos,
rRec.cant_reclamosOI,
rRec.cant_trab_realiz,
rRec.cant_reclamos_mensual,
rRec.cant_reclamosOI_mensual,
rRec.cant_trab_realiz_mensual
FROM biripit_pre_dw_silob.PDW_resumen_mensual_reclamos rRec
WHERE rRec.flag_insert IS NOT NULL
ON DUPLICATE KEY UPDATE
WID_año = rRec.WID_año,
WID_mes = rRec.WID_mes,
WID_area = rRec.WID_area,
cant_reclamos = rRec.cant_reclamos,
cant_reclamosOI = rRec.cant_reclamosOI,
cant_trab_realiz = rRec.cant_trab_realiz,
cant_reclamos_mensual = rRec.cant_reclamos_mensual,
cant_reclamosOI_mensual = rRec.cant_reclamosOI_mensual,
cant_trab_realiz_mensual = rRec.cant_trab_realiz_mensual;
SET foreign_key_checks = 1;
UPDATE biripit_pre_dw_silob.PDW_resumen_mensual_reclamos rRec SET rRec.flag_insert=null;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insTransAnalisis_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insTransAnalisis_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insTransAnalisis_DW`()
BEGIN
SET foreign_key_checks = 0;
INSERT INTO biripit_dw_silob.DW_analisis (WID_analisis,WID_resumen_mensual_ingreso,id_analisis,id_tipo_analisis,variacion,id_muestra,cod_norma_val,
cod_unidad,cod_acreditacion,id_envase,id_set,id_cartacontrol,last_update)
SELECT 
ana.WID_analisis,ana.WID_resumen_mensual_ingreso,ana.id_analisis,ana.id_tipo_analisis,ana.variacion,ana.id_muestra,ana.cod_norma_val,
ana.cod_unidad,ana.cod_acreditacion,ana.id_envase,ana.id_set,ana.id_cartacontrol,ana.last_update
FROM biripit_pre_dw_silob.PDW_analisis ana 
WHERE ana.flag_insert IS NOT NULL
ON DUPLICATE KEY UPDATE 
WID_resumen_mensual_ingreso = ana.WID_resumen_mensual_ingreso,
id_analisis = ana.id_analisis,
id_tipo_analisis = ana.id_tipo_analisis,
variacion = ana.variacion,
id_muestra = ana.id_muestra,
cod_norma_val = ana.cod_norma_val,
cod_unidad = ana.cod_unidad,
cod_acreditacion = ana.cod_acreditacion,
id_envase = ana.id_envase,
id_set = ana.id_set,
id_cartacontrol = ana.id_cartacontrol,
last_update = ana.last_update;
SET foreign_key_checks = 1;
UPDATE biripit_pre_dw_silob.PDW_analisis ana SET ana.flag_insert=null;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insTransEncuestas_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insTransEncuestas_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insTransEncuestas_DW`()
BEGIN
	SET foreign_key_checks = 0;
INSERT INTO DW_encuestas (
WID_encuesta,
WID_resumen_mensual_encuesta,
id_encuesta,
id_pregunta,
valor_pregunta,
id_contacto,
codigo,
fecha,
area,
flag_muestreo,
flag_analisis,
mejora,
observacion
)
SELECT 
encu.WID_encuesta,
encu.WID_resumen_mensual_encuesta,
encu.id_encuesta,
encu.id_pregunta,
encu.valor_pregunta,
encu.id_contacto,
encu.codigo,
encu.fecha,
encu.area,
encu.flag_muestreo,
encu.flag_analisis,
encu.mejora,
encu.observacion
FROM biripit_pre_dw_silob.PDW_encuestas encu
WHERE encu.flag_insert IS NOT NULL
ON DUPLICATE KEY UPDATE
WID_resumen_mensual_encuesta = encu.WID_resumen_mensual_encuesta,
id_encuesta = encu.id_encuesta,
id_pregunta = encu.id_pregunta,
valor_pregunta = encu.valor_pregunta,
id_contacto = encu.id_contacto,
codigo = encu.codigo,
fecha = encu.fecha,
area = encu.area,
flag_muestreo = encu.flag_muestreo,
flag_analisis = encu.flag_analisis,
mejora = encu.mejora,
observacion = encu.observacion;
SET foreign_key_checks = 1;
UPDATE biripit_pre_dw_silob.PDW_encuestas encu SET encu.flag_insert=null;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insTransIngresos_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insTransIngresos_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insTransIngresos_DW`()
BEGIN
	INSERT INTO biripit_dw_silob.DW_ingresos(WID_ingreso,id_ingreso,id_tipo_ingreso,id_cliente,id_dependencia,id_usuario_ingreso,id_usuario_validacion,id_factura,nro_ingreso,
raya,flag_reemplazado,flag_foto_informe,flag_carta,flag_sma,titular_proyecto,rut_titular,representante,rut_representante,proyecto,instrumentos,muestreador,
nro_requerimiento,fh_validacion,fecha_ingreso,hora_ingreso,certificacion_snp,nro_formulario_snp,cod_destino_snp,cod_categoria,lugar_descarga,f_i_muestreo,
f_muestreo,fh_almacenamiento,h_i_muestreo,h_t_muestreo,f_i_verificacion,f_t_verificacion,cont_muestreo,nro_muestreo,id_muestreador,nro_muestreo2,id_muestreador2,
cod_entrega,entidad_m,flag_limites,lugar_muestreo,envases_cliente,coleman_cliente,otros_bienes_cliente,fh_informe,flag_caudal,flag_compuesta,fh_v_destino0,
fh_s_destino0,cod_destino1,fh_i_destino1,fh_s_destino1,cod_destino2,fh_i_destino2,fh_s_destino2,cod_destino3,fh_i_destino3,fh_s_destino3,cod_destino4,
fh_i_destino4,fh_s_destino4,cod_destino5,nro_fact,fh_fact,monto_muestreo,monto_muestreo_oi,monto_analisis,flag_pagado,nro_n_credito,monto_n_credito,
file_cotizacion,transporte_envio1,nro_envio1,transporte_envio2,nro_envio2,persona_retira,contacto_retira,persona_recibe,contacto_recibe,fecha_recibe,
id_us_destino0,id_us_destino1,id_us_destino2,id_us_destino3,id_us_destino4,flag_infact,file_recepcion,estado_caja,medio_transporte,comentarios,cod_informe,
flag_prioritario,abr,flag_estado,flag_avisado,cod_rechazo,file_acta,last_update,flag_aviso_fd,flag_composito_lab,fh_preparacion_c,preparador,cantEnvases,
nro_carpeta_snp,inspector_snp,f_envio_mts,fecha_publicacion)
SELECT 
	ing.WID_ingreso,
	ing.id_ingreso,
	ing.id_tipo_ingreso,
	ing.id_cliente,
	ing.id_dependencia,
	ing.id_usuario_ingreso,
	ing.id_usuario_validacion,
	ing.id_factura,
	ing.nro_ingreso,
	ing.raya,
	ing.flag_reemplazado,
	ing.flag_foto_informe,
	ing.flag_carta,
	ing.flag_sma,
	ing.titular_proyecto,
	ing.rut_titular,
	ing.representante,
	ing.rut_representante,
	ing.proyecto,
	ing.instrumentos,
	ing.muestreador,
	ing.nro_requerimiento,
	ing.fh_validacion,
	ing.fecha_ingreso,
	ing.hora_ingreso,
	ing.certificacion_snp,
	ing.nro_formulario_snp,
	ing.cod_destino_snp,
	ing.cod_categoria,
	ing.lugar_descarga,
	ing.f_i_muestreo,
	ing.f_muestreo,
	ing.fh_almacenamiento,
	ing.h_i_muestreo,
	ing.h_t_muestreo,
	ing.f_i_verificacion,
	ing.f_t_verificacion,
	ing.cont_muestreo,
	ing.nro_muestreo,
	ing.id_muestreador,
	ing.nro_muestreo2,
	ing.id_muestreador2,
	ing.cod_entrega,
	ing.entidad_m,
	ing.flag_limites,
	ing.lugar_muestreo,
	ing.envases_cliente,
	ing.coleman_cliente,
	ing.otros_bienes_cliente,
	ing.fh_informe,
	ing.flag_caudal,
	ing.flag_compuesta,
	ing.fh_v_destino0,
	ing.fh_s_destino0,
	ing.cod_destino1,
	ing.fh_i_destino1,
	ing.fh_s_destino1,
	ing.cod_destino2,
	ing.fh_i_destino2,
	ing.fh_s_destino2,
	ing.cod_destino3,
	ing.fh_i_destino3,
	ing.fh_s_destino3,
	ing.cod_destino4,
	ing.fh_i_destino4,
	ing.fh_s_destino4,
	ing.cod_destino5,
	ing.nro_fact,
	ing.fh_fact,
	ing.monto_muestreo,
	ing.monto_muestreo_oi,
	ing.monto_analisis,
	ing.flag_pagado,
	ing.nro_n_credito,
	ing.monto_n_credito,
	ing.file_cotizacion,
	ing.transporte_envio1,
	ing.nro_envio1,
	ing.transporte_envio2,
	ing.nro_envio2,
	ing.persona_retira,
	ing.contacto_retira,
	ing.persona_recibe,
	ing.contacto_recibe,
	ing.fecha_recibe,
	ing.id_us_destino0,
	ing.id_us_destino1,
	ing.id_us_destino2,
	ing.id_us_destino3,
	ing.id_us_destino4,
	ing.flag_infact,
	ing.file_recepcion,
	ing.estado_caja,
	ing.medio_transporte,
	ing.comentarios,
	ing.cod_informe,
	ing.flag_prioritario,
	ing.abr,
	ing.flag_estado,
	ing.flag_avisado,
	ing.cod_rechazo,
	ing.file_acta,
	ing.last_update,
	ing.flag_aviso_fd,
	ing.flag_composito_lab,
	ing.fh_preparacion_c,
	ing.preparador,
	ing.cantEnvases,
	ing.nro_carpeta_snp,
	ing.inspector_snp,
	ing.f_envio_mts,
	ing.fecha_publicacion
FROM
	biripit_pre_dw_silob.PDW_ingresos ing
WHERE ing.flag_insert IS NOT NULL
ON DUPLICATE KEY UPDATE
  id_ingreso =ing.id_ingreso,
	id_tipo_ingreso=ing.id_tipo_ingreso,
	id_cliente=ing.id_cliente,
	id_dependencia=ing.id_dependencia,
	id_usuario_ingreso=ing.id_usuario_ingreso,
	id_usuario_validacion=ing.id_usuario_validacion,
	id_factura=ing.id_factura,
	nro_ingreso=ing.nro_ingreso,
	raya=ing.raya,
	flag_reemplazado=ing.flag_reemplazado,
	flag_foto_informe=ing.flag_foto_informe,
	flag_carta=ing.flag_carta,
	flag_sma=ing.flag_sma,
	titular_proyecto=ing.titular_proyecto,
	rut_titular=ing.rut_titular,
	representante=ing.representante,
	rut_representante=ing.rut_representante,
	proyecto=ing.proyecto,
	instrumentos=ing.instrumentos,
	muestreador=ing.muestreador,
	nro_requerimiento=ing.nro_requerimiento,
	fh_validacion=ing.fh_validacion,
	fecha_ingreso=ing.fecha_ingreso,
	hora_ingreso=ing.hora_ingreso,
	certificacion_snp=ing.certificacion_snp,
	nro_formulario_snp=ing.nro_formulario_snp,
	cod_destino_snp=ing.cod_destino_snp,
	cod_categoria=ing.cod_categoria,
	lugar_descarga=ing.lugar_descarga,
	f_i_muestreo=ing.f_i_muestreo,
	f_muestreo=ing.f_muestreo,
	fh_almacenamiento=ing.fh_almacenamiento,
	h_i_muestreo=ing.h_i_muestreo,
	h_t_muestreo=ing.h_t_muestreo,
	f_i_verificacion=ing.f_i_verificacion,
	f_t_verificacion=ing.f_t_verificacion,
	cont_muestreo=ing.cont_muestreo,
	nro_muestreo=ing.nro_muestreo,
	id_muestreador=ing.id_muestreador,
	nro_muestreo2=ing.nro_muestreo2,
	id_muestreador2=ing.id_muestreador2,
	cod_entrega=ing.cod_entrega,
	entidad_m=ing.entidad_m,
	flag_limites=ing.flag_limites,
	lugar_muestreo=ing.lugar_muestreo,
	envases_cliente=ing.envases_cliente,
	coleman_cliente=ing.coleman_cliente,
	otros_bienes_cliente=ing.otros_bienes_cliente,
	fh_informe=ing.fh_informe,
	flag_caudal=ing.flag_caudal,
	flag_compuesta=ing.flag_compuesta,
	fh_v_destino0=ing.fh_v_destino0,
	fh_s_destino0=ing.fh_s_destino0,
	cod_destino1=ing.cod_destino1,
	fh_i_destino1=ing.fh_i_destino1,
	fh_s_destino1=ing.fh_s_destino1,
	cod_destino2=ing.cod_destino2,
	fh_i_destino2=ing.fh_i_destino2,
	fh_s_destino2=ing.fh_s_destino2,
	cod_destino3=ing.cod_destino3,
	fh_i_destino3=ing.fh_i_destino3,
	fh_s_destino3=ing.fh_s_destino3,
	cod_destino4=ing.cod_destino4,
	fh_i_destino4=ing.fh_i_destino4,
	fh_s_destino4=ing.fh_s_destino4,
	cod_destino5=ing.cod_destino5,
	nro_fact=ing.nro_fact,
	fh_fact=ing.fh_fact,
	monto_muestreo=ing.monto_muestreo,
	monto_muestreo_oi=ing.monto_muestreo_oi,
	monto_analisis=ing.monto_analisis,
	flag_pagado=ing.flag_pagado,
	nro_n_credito=ing.nro_n_credito,
	monto_n_credito=ing.monto_n_credito,
	file_cotizacion=ing.file_cotizacion,
	transporte_envio1=ing.transporte_envio1,
	nro_envio1=ing.nro_envio1,
	transporte_envio2=ing.transporte_envio2,
	nro_envio2=ing.nro_envio2,
	persona_retira=ing.persona_retira,
	contacto_retira=ing.contacto_retira,
	persona_recibe=ing.persona_recibe,
	contacto_recibe=ing.contacto_recibe,
	fecha_recibe=ing.fecha_recibe,
	id_us_destino0=ing.id_us_destino0,
	id_us_destino1=ing.id_us_destino1,
	id_us_destino2=ing.id_us_destino2,
	id_us_destino3=ing.id_us_destino3,
	id_us_destino4=ing.id_us_destino4,
	flag_infact=ing.flag_infact,
	file_recepcion=ing.file_recepcion,
	estado_caja=ing.estado_caja,
	medio_transporte=ing.medio_transporte,
	comentarios=ing.comentarios,
	cod_informe=ing.cod_informe,
	flag_prioritario=ing.flag_prioritario,
	abr=ing.abr,
	flag_estado=ing.flag_estado,
	flag_avisado=ing.flag_avisado,
	cod_rechazo=ing.cod_rechazo,
	file_acta=ing.file_acta,
	last_update=ing.last_update,
	flag_aviso_fd=ing.flag_aviso_fd,
	flag_composito_lab=ing.flag_composito_lab,
	fh_preparacion_c=ing.fh_preparacion_c,
	preparador=ing.preparador,
	cantEnvases=ing.cantEnvases,
	nro_carpeta_snp=ing.nro_carpeta_snp,
	inspector_snp=ing.inspector_snp,
	f_envio_mts=ing.f_envio_mts,
	fecha_publicacion=ing.fecha_publicacion;
	UPDATE biripit_pre_dw_silob.PDW_ingresos ing SET ing.flag_insert = null;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insTransMuestras_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insTransMuestras_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insTransMuestras_DW`()
BEGIN
INSERT INTO biripit_dw_silob.DW_muestras(WID_muestra,id_muestra,identificacion,duplicado,material_id,id_ingreso,id_tipo_muestra,
clave,cod_submuestra,id_desc_prod,descripcion_muestra,cod_especie,t_ingreso,t_ingreso_error,t_corregida,id_termometro,
vol_ingreso,ph_ingreso,flag_primario,flag_secundario,flag_refrigeracion,cant_refrigerante,flag_condicion,flag_identificacion,
flag_testigo,flag_tmuestra,flag_nmuestras,flag_descripcion,flag_especie,flag_aceptado,estado_v,cod_val_resultados,n_muestras,
obs_verificacion,fh_verificacion,idus_verificacion,foto,fecha_foto,hora_caudal,caudal,formato_in,fecha_faena,fecha_elaboracion,
fecha_vencimiento,temp_muestreo,frigorifico,cod_establecimiento,pais_origen,n_cortes,n_cajas,lote,datos_camion,flag_composito,
contacto_manip,actividad_manip,seccion_manip,sala_manip,flag_cuadrante,cod_cuadrante,cod_regionh,cod_etapah,cod_consumoh,
cod_tarroh,cod_peso_exph,cod_psmbh,cod_excepcionh,flag_acta,last_update)
SELECT 
	mue.WID_muestra,
	mue.id_muestra,
	mue.identificacion,
	mue.duplicado,
	mue.material_id,
	mue.id_ingreso,
	mue.id_tipo_muestra,
	mue.clave,
	mue.cod_submuestra,
	mue.id_desc_prod,
	mue.descripcion_muestra,
	mue.cod_especie,
	mue.t_ingreso,
	mue.t_ingreso_error,
	mue.t_corregida,
	mue.id_termometro,
	mue.vol_ingreso,
	mue.ph_ingreso,
	mue.flag_primario,
	mue.flag_secundario,
	mue.flag_refrigeracion,
	mue.cant_refrigerante,
	mue.flag_condicion,
	mue.flag_identificacion,
	mue.flag_testigo,
	mue.flag_tmuestra,
	mue.flag_nmuestras,
	mue.flag_descripcion,
	mue.flag_especie,
	mue.flag_aceptado,
	mue.estado_v,
	mue.cod_val_resultados,
	mue.n_muestras,
	mue.obs_verificacion,
	mue.fh_verificacion,
	mue.idus_verificacion,
	mue.foto,
	mue.fecha_foto,
	mue.hora_caudal,
	mue.caudal,
	mue.formato_in,
	mue.fecha_faena,
	mue.fecha_elaboracion,
	mue.fecha_vencimiento,
	mue.temp_muestreo,
	mue.frigorifico,
	mue.cod_establecimiento,
	mue.pais_origen,
	mue.n_cortes,
	mue.n_cajas,
	mue.lote,
	mue.datos_camion,
	mue.flag_composito,
	mue.contacto_manip,
	mue.actividad_manip,
	mue.seccion_manip,
	mue.sala_manip,
	mue.flag_cuadrante,
	mue.cod_cuadrante,
	mue.cod_regionh,
	mue.cod_etapah,
	mue.cod_consumoh,
	mue.cod_tarroh,
	mue.cod_peso_exph,
	mue.cod_psmbh,
	mue.cod_excepcionh,
	mue.flag_acta,
	mue.last_update
FROM
	biripit_pre_dw_silob.PDW_muestras mue
ON DUPLICATE KEY UPDATE
id_muestra = mue.id_muestra,
identificacion= mue.identificacion,
duplicado	= mue.duplicado,
material_id	= mue.material_id,
id_ingreso	= mue.id_ingreso,
id_tipo_muestra= mue.id_tipo_muestra,
clave= mue.clave,
cod_submuestra	= mue.cod_submuestra,
id_desc_prod	= mue.id_desc_prod,
descripcion_muestra	= mue.descripcion_muestra,
cod_especie	= mue.cod_especie,
t_ingreso	= mue.t_ingreso,
t_ingreso_error	= mue.t_ingreso_error,
t_corregida	= mue.t_corregida,
id_termometro	= mue.id_termometro,
vol_ingreso	= mue.vol_ingreso,
ph_ingreso	= mue.ph_ingreso,
flag_primario	= mue.flag_primario,
flag_secundario	= mue.flag_secundario,
flag_refrigeracion	= mue.flag_refrigeracion,
cant_refrigerante	= mue.cant_refrigerante,
flag_condicion	= mue.flag_condicion,
flag_identificacion	= mue.flag_identificacion,
flag_testigo	= mue.flag_testigo,
flag_tmuestra	= mue.flag_tmuestra,
flag_nmuestras	= mue.flag_nmuestras,
flag_descripcion	= mue.flag_descripcion,
flag_especie	= mue.flag_especie,
flag_aceptado	= mue.flag_aceptado,
estado_v	= mue.estado_v,
cod_val_resultados	= mue.cod_val_resultados,
n_muestras	= mue.n_muestras,
obs_verificacion	= mue.obs_verificacion,
fh_verificacion	= mue.fh_verificacion,
idus_verificacion	= mue.idus_verificacion,
foto	= mue.foto,
fecha_foto	= mue.fecha_foto,
hora_caudal	= mue.hora_caudal,
caudal	= mue.caudal,
formato_in	= mue.formato_in,
fecha_faena	= mue.fecha_faena,
fecha_elaboracion	= mue.fecha_elaboracion,
fecha_vencimiento	= mue.fecha_vencimiento,
temp_muestreo	= mue.temp_muestreo,
frigorifico	= mue.frigorifico,
cod_establecimiento	= mue.cod_establecimiento,
pais_origen	= mue.pais_origen,
n_cortes	= mue.n_cortes,
n_cajas	= mue.n_cajas,
lote	= mue.lote,
datos_camion	= mue.datos_camion,
flag_composito	= mue.flag_composito,
contacto_manip	= mue.contacto_manip,
actividad_manip	= mue.actividad_manip,
seccion_manip	= mue.seccion_manip,
sala_manip	= mue.sala_manip,
flag_cuadrante	= mue.flag_cuadrante,
cod_cuadrante	= mue.cod_cuadrante,
cod_regionh	= mue.cod_regionh,
cod_etapah	= mue.cod_etapah,
cod_consumoh	= mue.cod_consumoh,
cod_tarroh	= mue.cod_tarroh,
cod_peso_exph	= mue.cod_peso_exph,
cod_psmbh	= mue.cod_psmbh,
cod_excepcionh	= mue.cod_excepcionh,
flag_acta	= mue.flag_acta,
last_update	= mue.last_update;
UPDATE biripit_pre_dw_silob.PDW_muestras mue SET mue.flag_insert = null;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insTransReclamos_DW
-- ----------------------------
DROP PROCEDURE IF EXISTS `insTransReclamos_DW`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insTransReclamos_DW`()
BEGIN
	SET foreign_key_checks = 0;
INSERT INTO biripit_dw_silob.DW_reclamos (WID_reclamo,WID_resumen_mensual_reclamo,id_reclamo,id_contacto_tecnico,ext_nombre,ext_mail,deteccion,area,descripcion,
id_ingreso_implicado,fh_abierto,fh_cierre,flag_aviso_cl,flag_justificado,justificacion,flag_implicancias,fecha_tnc,
just_implicancia,flag_ea,flag_oi,fecha_aviso_oi,id_ingreso_corregido,fecha_carta,fecha_mail,participantes,estado,observaciones,
flag_eliminado)
SELECT 
rec.WID_reclamo,rec.WID_resumen_mensual_reclamo,rec.id_reclamo,rec.id_contacto_tecnico,rec.ext_nombre,rec.ext_mail,rec.deteccion,rec.area,rec.descripcion,
rec.id_ingreso_implicado,rec.fh_abierto,rec.fh_cierre,rec.flag_aviso_cl,rec.flag_justificado,rec.justificacion,
rec.flag_implicancias,rec.fecha_tnc,rec.just_implicancia,rec.flag_ea,rec.flag_oi,rec.fecha_aviso_oi,rec.id_ingreso_corregido,
rec.fecha_carta,rec.fecha_mail,rec.participantes,rec.estado,rec.observaciones,rec.flag_eliminado
FROM biripit_pre_dw_silob.PDW_reclamos rec
ON DUPLICATE KEY UPDATE
WID_resumen_mensual_reclamo = rec.WID_resumen_mensual_reclamo,
id_reclamo = rec.id_reclamo ,
id_contacto_tecnico = rec.id_contacto_tecnico,
ext_nombre = rec.ext_nombre,
ext_mail = rec.ext_mail,
deteccion = rec.deteccion,
area = rec.area,
descripcion = rec.descripcion,
id_ingreso_implicado = rec.id_ingreso_implicado,
fh_abierto = rec.fh_abierto,
fh_cierre = rec.fh_cierre,
flag_aviso_cl = rec.flag_aviso_cl,
flag_justificado = rec.flag_justificado,
justificacion = rec.justificacion,
flag_implicancias = rec.flag_implicancias,
fecha_tnc = rec.fecha_tnc,
just_implicancia = rec.just_implicancia,
flag_ea = rec.flag_ea,
flag_oi = rec.flag_oi,
fecha_aviso_oi = rec.fecha_aviso_oi,
id_ingreso_corregido = rec.id_ingreso_corregido,
fecha_carta = rec.fecha_carta,
fecha_mail = rec.fecha_mail,
participantes = rec.participantes,
estado = rec.estado,
observaciones = rec.observaciones,
flag_eliminado = rec.flag_eliminado;
SET foreign_key_checks = 1;
UPDATE biripit_pre_dw_silob.PDW_reclamos ta SET ta.flag_insert=null;
END
;;
DELIMITER ;
