/*
Navicat MySQL Data Transfer

Source Server         : dataWareHouse
Source Server Version : 50557
Source Host           : bi.ripit.cl:3306
Source Database       : biripit_stage_dw_silob

Target Server Type    : MYSQL
Target Server Version : 50557
File Encoding         : 65001

Date: 2017-10-02 15:45:35
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for analisis
-- ----------------------------
DROP TABLE IF EXISTS `analisis`;
CREATE TABLE `analisis` (
  `id_analisis` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `id_tipo_analisis` int(11) NOT NULL COMMENT 'Identificador del tipo de análisis (tablas "tipos_analisis").',
  `variacion` varchar(50) DEFAULT NULL COMMENT 'Variación del análisis.',
  `id_muestra` int(11) NOT NULL COMMENT 'Identificador de la muestra (tabla "muestras").',
  `cod_norma_val` int(11) DEFAULT NULL COMMENT 'Código general de la norma de validación utilizada (dominio SIS_VALIDA).',
  `cod_unidad` int(6) DEFAULT NULL COMMENT 'Código general de la unidad asociada (dominio SIS_UNIMED).',
  `cod_acreditacion` int(6) DEFAULT NULL COMMENT 'Código general de la acreditación utilizada (dominio SIS_ACREDI).',
  `id_envase` int(6) DEFAULT NULL COMMENT 'Identificador del envase del análisis (tabla "envases_analisis").',
  `id_set` int(11) DEFAULT NULL COMMENT 'Identificador del set de análisis (tabla "set_analisis").',
  `id_cartacontrol` int(11) DEFAULT NULL,
  `last_update` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_analisis`),
  UNIQUE KEY `un_tavm` (`id_tipo_analisis`,`variacion`,`id_muestra`) USING BTREE,
  KEY `id_tipo_analisis` (`id_tipo_analisis`) USING BTREE,
  KEY `id_muestra` (`id_muestra`) USING BTREE,
  KEY `i_idset` (`id_set`) USING BTREE,
  KEY `ind_idcarta` (`id_cartacontrol`) USING BTREE,
  CONSTRAINT `analisis_ibfk_1` FOREIGN KEY (`id_muestra`) REFERENCES `muestras` (`id_muestra`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `analisis_tanali_ibfk_2` FOREIGN KEY (`id_tipo_analisis`) REFERENCES `tipos_analisis` (`id_tipo_analisis`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1741506 DEFAULT CHARSET=utf8 COMMENT='Análisis registrados en el sistema acompañados de sus atributos.';

-- ----------------------------
-- Table structure for clientes
-- ----------------------------
DROP TABLE IF EXISTS `clientes`;
CREATE TABLE `clientes` (
  `id_cliente` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `razon_social` varchar(1000) NOT NULL COMMENT 'Razón social del cliente.',
  `nombre` varchar(1000) DEFAULT NULL COMMENT 'Nombre del cliente.',
  `nro_rut` int(9) DEFAULT NULL COMMENT 'Rol único tributario (sin dígito verificador).',
  `dv_rut` char(1) DEFAULT NULL COMMENT 'Dígito verificador del RUT.',
  `direccion` varchar(500) DEFAULT NULL COMMENT 'Dirección del cliente.',
  `cont_facturacion` varchar(500) DEFAULT NULL COMMENT 'Nombre del contacto de facturación.',
  `fono_cont` varchar(25) DEFAULT NULL COMMENT 'Teléfono del contacto de facturación.',
  `fono2_cont` varchar(25) DEFAULT NULL COMMENT 'Segundo teléfono del contacto de facturación.',
  `mail_cont` varchar(200) DEFAULT NULL COMMENT 'Correo electrónico del contacto de facturación.',
  `cod_ciiu` int(11) DEFAULT NULL COMMENT 'Código de actividad económica (dominio SIS_CIIU).',
  `cod_status` int(11) DEFAULT NULL COMMENT 'Código del estado del cliente (dominio SIS_STATUS).',
  `pub_local` tinyint(1) DEFAULT NULL COMMENT 'En desuso.',
  `pub_descrip` tinyint(1) DEFAULT NULL COMMENT 'En desuso.',
  `pub_fecham` tinyint(1) DEFAULT NULL COMMENT 'En desuso.',
  `estado_cl` enum('Creado','Validado','Modificado','Eliminado') DEFAULT NULL COMMENT 'Estado del cliente (posibles valores: "Creado", "Validado", "Modificado", "Eliminado").',
  `version` int(1) DEFAULT NULL COMMENT 'Versión del cliente.',
  `flag_vigente` tinyint(1) DEFAULT NULL COMMENT 'Indica si el cliente está vigente (1 si lo está, 0 o NULL si no lo está).',
  `id_usuario_upin` int(11) DEFAULT NULL COMMENT 'Usuario registrador o actualizador de los datos del cliente (tabla "usuarios"):',
  `id_usuario_vali` int(11) DEFAULT NULL COMMENT 'Identificador del usuario validador.',
  `update_timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la última actualización del cliente.',
  `flag_eliminado` tinyint(1) DEFAULT NULL COMMENT 'Indica si el usuario está eliminado (1 si lo está, 0 o NULL si no lo está).',
  PRIMARY KEY (`id_cliente`)
) ENGINE=InnoDB AUTO_INCREMENT=2266 DEFAULT CHARSET=utf8 COMMENT='Clientes registrados en el sistema, junto con sus atributos.';

-- ----------------------------
-- Table structure for codigos_g
-- ----------------------------
DROP TABLE IF EXISTS `codigos_g`;
CREATE TABLE `codigos_g` (
  `id_codigo_g` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `cod_tabla` varchar(10) NOT NULL COMMENT 'Código de la tabla a la cual pertenece el código general (tabla "tablas_g").',
  `descripcion` varchar(500) DEFAULT NULL COMMENT 'Descripción del código general.',
  `atributo` varchar(200) DEFAULT NULL COMMENT 'Primer atributo del código general.',
  `atributo2` varchar(200) DEFAULT NULL COMMENT 'Segundo atributo del código general.',
  `orden_campo` int(5) DEFAULT NULL COMMENT 'Orden del códig general al interior de su tabla.',
  `flag_vig` tinyint(1) DEFAULT NULL COMMENT 'Indica si el código general se encuentra vigente (1 si lo está , 0 o NULL si no lo está).',
  `id_usuario_r` int(11) DEFAULT NULL COMMENT 'Identificador del usuario registrador del código general (tabla "usuarios").',
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id_codigo_g`),
  KEY `i_desc` (`descripcion`(255)) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=3162 DEFAULT CHARSET=utf8 COMMENT='Códigos generales asociados a una determinada tabla general.';

-- ----------------------------
-- Table structure for contactos_dependencias
-- ----------------------------
DROP TABLE IF EXISTS `contactos_dependencias`;
CREATE TABLE `contactos_dependencias` (
  `id_con_dep` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `id_contacto_tecnico` int(11) DEFAULT NULL COMMENT 'Identificador del contacto técnico (tabla "contactos_tecnicos").',
  `id_dependencia` int(11) DEFAULT NULL COMMENT 'Identificador de la dependencia asociada al contacto técnico (tabla "dependencias"). ',
  `fecha_reg` datetime DEFAULT NULL COMMENT 'Fecha y hora de registro del contacto técnico en la dependencia.',
  `id_usuario` int(11) DEFAULT NULL COMMENT 'Identificador del usuario registrador del contacto en la dependencia (tabla "usuarios").',
  `flag_vigente` int(1) DEFAULT NULL COMMENT 'Indica si el contacto se encuentra vigente en la dependencia (1 si lo está, 0 o NULL si no lo está).',
  `last_update` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_con_dep`),
  KEY `id_dependencia` (`id_dependencia`) USING BTREE,
  KEY `id_contacto_tecnico` (`id_contacto_tecnico`) USING BTREE,
  CONSTRAINT `contactos_dependencias_ibfk_1` FOREIGN KEY (`id_dependencia`) REFERENCES `dependencias` (`id_dependencia`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contactos_dependencias_ibfk_2` FOREIGN KEY (`id_contacto_tecnico`) REFERENCES `contactos_tecnicos` (`id_contacto_tecnico`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17973 DEFAULT CHARSET=latin1 COMMENT='Contactos técnicos asociados a una determinada dependencia.';

-- ----------------------------
-- Table structure for contactos_tecnicos
-- ----------------------------
DROP TABLE IF EXISTS `contactos_tecnicos`;
CREATE TABLE `contactos_tecnicos` (
  `id_contacto_tecnico` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `id_dependencia` int(11) NOT NULL COMMENT 'Identificador de la dependencia asociada al contacto técnico (tabla "dependencias").',
  `nombre` varchar(100) DEFAULT NULL COMMENT 'Nombre del contacto técnico.',
  `nro_rut` varchar(10) DEFAULT NULL COMMENT 'RUT del contacto técnico.',
  `cod_cargo` int(6) DEFAULT NULL COMMENT 'Código general del cargo del contacto técnico.',
  `fono_1` varchar(30) DEFAULT NULL COMMENT 'Primer teléfono del contacto técnico.',
  `fono_2` varchar(30) DEFAULT NULL COMMENT 'Segundo teléfono del contacto técnico.',
  `mail` varchar(100) DEFAULT NULL COMMENT 'Correo electrónico del contacto técnico.',
  `nombre_usuario` varchar(100) DEFAULT NULL COMMENT 'Nombre de usuario del contacto técnico.',
  `pass` varchar(100) DEFAULT NULL COMMENT 'Contraseña del contacto técnico.',
  `flag_activo` char(1) DEFAULT NULL COMMENT 'Indica si el contacto técnico se encuentra vigente (1 si lo está, 0 o NULL si no lo está).',
  `cod_coordinador` int(10) DEFAULT NULL COMMENT 'Indica si es coordinador de un cliente en especifico o de todos.',
  `last_update` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id_contacto_tecnico`)
) ENGINE=InnoDB AUTO_INCREMENT=3416 DEFAULT CHARSET=latin1 COMMENT='Contactos técnicos asociados a una determinada dependencia.';

-- ----------------------------
-- Table structure for dependencias
-- ----------------------------
DROP TABLE IF EXISTS `dependencias`;
CREATE TABLE `dependencias` (
  `id_dependencia` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `id_cliente` int(11) NOT NULL COMMENT 'Identificador del cliente al que pertenece la dependencia (tabla "clientes").',
  `nombre` varchar(100) NOT NULL COMMENT 'Nombre de la dependencia.',
  `direccion` varchar(500) DEFAULT NULL COMMENT 'Dirección de la dependencia.',
  `gerencia` varchar(200) DEFAULT NULL COMMENT 'Gerencia a la que pertenece la dependencia.',
  `flag_activo` tinyint(1) DEFAULT NULL COMMENT 'Indica si la dependencia se encuentra activa (1 si lo está, 0 o NULL si no lo está).',
  `version` int(6) DEFAULT NULL COMMENT 'Versión de los datos de la dependencia.',
  `estado_dep` enum('Creado','Validado','Modificado','Baja','Eliminado') DEFAULT NULL COMMENT 'Estado de la dependencia (valores posibles: "Creado", "Validado", "Modificado", "Baja", "Eliminado").',
  `id_usuario_upin` int(11) DEFAULT NULL COMMENT 'Identificador del usuario registrador o actualizador de la dependencia (tabla "usuarios").',
  `id_usuario_vali` int(11) DEFAULT NULL COMMENT 'Identificador del usuario validador de la dependencia (tabla "usuarios").',
  `fh_update` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la última actualización de la dependencia.',
  PRIMARY KEY (`id_dependencia`),
  KEY `fk_id_clien_dep` (`id_cliente`),
  CONSTRAINT `fk_id_clien_dep` FOREIGN KEY (`id_cliente`) REFERENCES `clientes` (`id_cliente`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3203 DEFAULT CHARSET=utf8 COMMENT='Datos de las dependencias asociadas aun determinado cliente.';

-- ----------------------------
-- Table structure for encuestas
-- ----------------------------
DROP TABLE IF EXISTS `encuestas`;
CREATE TABLE `encuestas` (
  `id_encuesta` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `id_contacto` int(11) DEFAULT NULL COMMENT 'Identificador del contacto encuestado (tabla "contactos_tecnicos").',
  `codigo` varchar(10) DEFAULT NULL COMMENT 'Código de la encuesta (fecha de creación).',
  `fecha` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Fecha y hora en que se respondió la encuesta.',
  `area` char(1) DEFAULT NULL COMMENT 'Sigla del área de la encuesta.',
  `flag_muestreo` tinyint(1) DEFAULT NULL COMMENT 'Indica si la encuesta es respecto al servicio de muestreo (1 si lo es, 0 o NULL si no lo es).',
  `flag_analisis` tinyint(1) DEFAULT NULL COMMENT 'Indica si la encuesta es respecto al servicio de análisis (1 si lo es, 0 o NULL si no lo es).',
  `p1` tinyint(1) DEFAULT NULL COMMENT 'Respuesta de la pregunta 1.',
  `p2` tinyint(1) DEFAULT NULL COMMENT 'Respuesta de la pregunta 2.',
  `p3` tinyint(1) DEFAULT NULL COMMENT 'Respuesta de la pregunta 3.',
  `p4` tinyint(1) DEFAULT NULL COMMENT 'Respuesta de la pregunta 4.',
  `p5` tinyint(1) DEFAULT NULL COMMENT 'Respuesta de la pregunta 5.',
  `p6` tinyint(1) DEFAULT NULL COMMENT 'Respuesta de la pregunta 6.',
  `p7` tinyint(1) DEFAULT NULL COMMENT 'Respuesta de la pregunta 7.',
  `p8` tinyint(1) DEFAULT NULL COMMENT 'Respuesta de la pregunta 8.',
  `p9` tinyint(1) DEFAULT NULL COMMENT 'Respuesta de la pregunta 9.',
  `mejora` text COMMENT 'Mejoras sugeridas por el contacto.',
  `observacion` text COMMENT 'Observaciones del contacto.',
  PRIMARY KEY (`id_encuesta`),
  KEY `fk_id_cont_tec_2` (`id_contacto`),
  CONSTRAINT `fk_id_cont_tec_2` FOREIGN KEY (`id_contacto`) REFERENCES `contactos_dependencias` (`id_contacto_tecnico`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=246 DEFAULT CHARSET=latin1 COMMENT='Historial de las encuestas efectuadas a los clientes.';

-- ----------------------------
-- Table structure for ingresos
-- ----------------------------
DROP TABLE IF EXISTS `ingresos`;
CREATE TABLE `ingresos` (
  `id_ingreso` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `id_tipo_ingreso` int(11) DEFAULT NULL COMMENT 'Identificador del tipo de ingreso (tabla "tipos_ingresos").',
  `id_cliente` int(11) NOT NULL COMMENT 'Identificador del cliente asociado al ingreso (tabla "clientes").',
  `id_dependencia` int(11) DEFAULT NULL COMMENT 'Identificador de la dependencia de muestreo (tabla "dependencias").',
  `id_usuario_ingreso` int(11) NOT NULL COMMENT 'Identificador del usuario encargado del ingreso (tabla "usuarios").',
  `id_usuario_validacion` int(11) DEFAULT NULL COMMENT 'Identificador del usuario validador del ingreso (tabla "usuarios").',
  `id_factura` int(11) DEFAULT NULL COMMENT 'Identificador de la factura sociada al ingreso (tabla "facturas").',
  `nro_ingreso` varchar(100) DEFAULT NULL COMMENT 'Número del ingreso.',
  `raya` char(6) DEFAULT NULL COMMENT 'Raya del ingreso.',
  `flag_reemplazado` char(1) DEFAULT NULL COMMENT 'Indica si el ingreso fue reemplazado (1 si lo fue, 0 o NULL si no lo fue).',
  `flag_foto_informe` tinyint(1) DEFAULT NULL COMMENT 'Indica si el informe posee una fotografía de informe asociada.',
  `flag_carta` tinyint(1) DEFAULT NULL,
  `flag_sma` tinyint(1) DEFAULT NULL,
  `titular_proyecto` varchar(300) DEFAULT NULL COMMENT 'Nombre del titular del proyecto.',
  `rut_titular` varchar(200) DEFAULT NULL COMMENT 'RUT del titular.',
  `representante` varchar(300) DEFAULT NULL COMMENT 'Nombre del representante.',
  `rut_representante` varchar(200) DEFAULT NULL COMMENT 'Rut del representante.',
  `proyecto` varchar(200) DEFAULT NULL COMMENT 'Descripción del proyecto.',
  `instrumentos` varchar(200) DEFAULT NULL COMMENT 'Intrumentos asociados al ingreso.',
  `muestreador` varchar(200) DEFAULT NULL COMMENT 'Muestreador asociado al ingreso.',
  `nro_requerimiento` varchar(100) DEFAULT NULL COMMENT 'Número de requerimiento.',
  `fh_validacion` datetime DEFAULT NULL COMMENT 'Fecha de validación del ingreso.',
  `fecha_ingreso` date NOT NULL COMMENT 'Fecha del ingreso.',
  `hora_ingreso` time NOT NULL COMMENT 'Hora del ingreso.',
  `certificacion_snp` varchar(100) DEFAULT NULL COMMENT 'Indica si el ingreso es CPF (Sernapesca).',
  `nro_formulario_snp` varchar(100) DEFAULT NULL COMMENT 'Número de Sernapesca (sólo para muestras HB).',
  `cod_destino_snp` varchar(5) DEFAULT NULL COMMENT 'Código general del cambiado-muestreo con NCh43.',
  `cod_categoria` int(5) DEFAULT NULL COMMENT 'Código de la categoría asociada (dominio SIS_CATEGO).',
  `lugar_descarga` varchar(100) DEFAULT NULL COMMENT 'Idenficador del almacenaje de contramuestra (hidrobiológicos).',
  `f_i_muestreo` date DEFAULT NULL COMMENT 'Fecha de inicio de muestreo.',
  `f_muestreo` date DEFAULT NULL COMMENT 'Fecha de muestreo.',
  `fh_almacenamiento` datetime DEFAULT NULL COMMENT 'Fecha y hora de almacenamiento.',
  `h_i_muestreo` time DEFAULT NULL COMMENT 'Hora de inicio de muestreo.',
  `h_t_muestreo` time DEFAULT NULL COMMENT 'Hora de término del muestreo.',
  `f_i_verificacion` date DEFAULT NULL COMMENT 'Fecha de inicio de la verificación.',
  `f_t_verificacion` date DEFAULT NULL COMMENT 'Fecha de término de la verificación.',
  `cont_muestreo` varchar(500) DEFAULT NULL COMMENT 'Contacto durante el muestreo.',
  `nro_muestreo` varchar(30) DEFAULT NULL COMMENT 'Correlativo del muestreo.',
  `id_muestreador` int(11) DEFAULT NULL COMMENT 'Código del muestreador (dominio SIS_MUESTR).',
  `nro_muestreo2` int(20) DEFAULT NULL COMMENT 'Correlativo secundario de muestreo.',
  `id_muestreador2` int(11) DEFAULT NULL COMMENT 'Código del muestreador secundario (dominio SIS_MUESTR).',
  `cod_entrega` int(5) DEFAULT NULL COMMENT 'Código del tipo de entrega (dominio SIS_TIPENT).',
  `entidad_m` varchar(200) DEFAULT NULL COMMENT 'Nombre de la entidad muestreadora.',
  `flag_limites` tinyint(1) DEFAULT NULL,
  `lugar_muestreo` varchar(1000) DEFAULT NULL COMMENT 'Lugar de muestreo.',
  `envases_cliente` varchar(100) DEFAULT NULL COMMENT 'Cantidad de envases del cliente.',
  `coleman_cliente` varchar(100) DEFAULT NULL COMMENT 'Cantidad de coolers Coleman del cliente.',
  `otros_bienes_cliente` varchar(500) DEFAULT NULL COMMENT 'Descripción de otros bienes del cliente.',
  `fh_informe` datetime DEFAULT NULL COMMENT 'Fecha y hora de emisión del infrome.',
  `flag_caudal` char(1) DEFAULT NULL,
  `flag_compuesta` char(1) DEFAULT NULL,
  `fh_v_destino0` datetime DEFAULT NULL COMMENT 'Fecha y hora de verificación del destino 0.',
  `fh_s_destino0` datetime DEFAULT NULL COMMENT 'Fecha y hora de salida del destino 0.',
  `cod_destino1` int(5) DEFAULT NULL COMMENT 'Código del destino 1 del informe (dominio SIS_DESINF).',
  `fh_i_destino1` datetime DEFAULT NULL COMMENT 'Fecha y hora de ingreso del destino 1.',
  `fh_s_destino1` datetime DEFAULT NULL COMMENT 'Fecha y hora de salida del destino 1.',
  `cod_destino2` int(5) DEFAULT NULL COMMENT 'Código del destino 2 del informe (dominio SIS_DESINF)',
  `fh_i_destino2` datetime DEFAULT NULL COMMENT 'Fecha y hora de ingreso del destino 2.',
  `fh_s_destino2` datetime DEFAULT NULL COMMENT 'Fecha y hora de salida del destino 2.',
  `cod_destino3` int(5) DEFAULT NULL COMMENT 'Código del destino 3 del informe (dominio SIS_DESINF)',
  `fh_i_destino3` datetime DEFAULT NULL COMMENT 'Fecha y hora de ingreso del destino 3.',
  `fh_s_destino3` datetime DEFAULT NULL COMMENT 'Fecha y hora de salida del destino 3.',
  `cod_destino4` int(5) DEFAULT NULL COMMENT 'Código del destino 4 del informe (dominio SIS_DESINF)',
  `fh_i_destino4` datetime DEFAULT NULL COMMENT 'Fecha y hora de ingreso del destino 4.',
  `fh_s_destino4` datetime DEFAULT NULL COMMENT 'Fecha y hora de salida del destino 4.',
  `cod_destino5` int(5) DEFAULT NULL COMMENT 'Código del destino 5 del informe (dominio SIS_DESINF)',
  `nro_fact` varchar(20) DEFAULT NULL COMMENT 'Número de factura.',
  `fh_fact` datetime DEFAULT NULL COMMENT 'Fecha y hora de facturación.',
  `monto_muestreo` int(13) DEFAULT NULL COMMENT 'Monto de muestreo.',
  `monto_muestreo_oi` int(13) DEFAULT NULL COMMENT 'Monto de muestreo (Sernapesca).',
  `monto_analisis` int(13) DEFAULT NULL COMMENT 'Monto del análisis.',
  `flag_pagado` tinyint(1) DEFAULT NULL COMMENT 'Indica si el ingreso está pagado (1 si lo está, 0 o NULL si no lo está).',
  `nro_n_credito` varchar(20) DEFAULT NULL COMMENT 'Número de crédito.',
  `monto_n_credito` int(13) DEFAULT NULL COMMENT 'Monto de crédito.',
  `file_cotizacion` varchar(200) DEFAULT NULL COMMENT 'Archivo de cotización.',
  `transporte_envio1` int(5) DEFAULT NULL COMMENT 'Código del transporte de envío 1 (dominio SIS_TRASNP).',
  `nro_envio1` varchar(50) DEFAULT NULL COMMENT 'Número de envío 1.',
  `transporte_envio2` int(5) DEFAULT NULL COMMENT 'Código del transporte de envío 2 (dominio SIS_TRASNP).',
  `nro_envio2` varchar(50) DEFAULT NULL COMMENT 'Número de envío 2.',
  `persona_retira` varchar(100) DEFAULT NULL COMMENT 'Nombre de la persona que retira el envío.',
  `contacto_retira` varchar(200) DEFAULT NULL COMMENT 'Contacto de la persona que retira el envío.',
  `persona_recibe` varchar(100) DEFAULT NULL COMMENT 'Nombre de la persona que recibe el envío.',
  `contacto_recibe` varchar(200) DEFAULT NULL COMMENT 'Contacto de la persona que recibe el envío.',
  `fecha_recibe` date DEFAULT NULL COMMENT 'Fecha de recepción del envío.',
  `id_us_destino0` int(5) DEFAULT NULL COMMENT 'Identificador de destino 0 (tabla "destinos_exportacion").',
  `id_us_destino1` int(5) DEFAULT NULL COMMENT 'Identificador de destino 1 (tabla "destinos_exportacion").',
  `id_us_destino2` int(5) DEFAULT NULL COMMENT 'Identificador de destino 2 (tabla "destinos_exportacion").',
  `id_us_destino3` int(5) DEFAULT NULL COMMENT 'Identificador de destino 3 (tabla "destinos_exportacion").',
  `id_us_destino4` int(5) DEFAULT NULL COMMENT 'Identificador de destino 4 (tabla "destinos_exportacion").',
  `flag_infact` tinyint(1) DEFAULT NULL COMMENT 'Indica si el informe se despacha con factura (1 si se despacha con informe, 0 o NULL si no se despacha con él).',
  `file_recepcion` varchar(500) DEFAULT NULL COMMENT 'Archivo asociado a la recepción.',
  `estado_caja` int(5) DEFAULT NULL COMMENT 'Estado de la verificacion (1 cuando tiene estado, 0 o NULL cuando no lo tiene).',
  `medio_transporte` int(5) DEFAULT NULL COMMENT 'Medio de transporte.',
  `comentarios` text COMMENT 'Comentarios del ingreso.',
  `cod_informe` int(5) DEFAULT NULL COMMENT 'Código del formato de informe (dominio SIS_FORINF).',
  `flag_prioritario` char(1) DEFAULT NULL COMMENT 'Indica si el ingreso es prioritario. Si lo es continua con los flag de estado y avisado.',
  `abr` varchar(10) DEFAULT NULL COMMENT 'Cuando es prioritario, se puede poner una abreviacion para mostrar en información de ingreso.',
  `flag_estado` tinyint(1) DEFAULT NULL COMMENT 'Estado de la verificacion (1 cuando tiene estado, 0 o NULL si no lo tiene).',
  `flag_avisado` tinyint(1) DEFAULT NULL COMMENT 'Indica si el ingreso fue avisado (verificacion de muestras). ',
  `cod_rechazo` int(11) DEFAULT NULL COMMENT 'Si no es NULL indica por qué se rechaza un ingreso (dominio SIS_RECHAZ).',
  `file_acta` varchar(500) DEFAULT NULL COMMENT 'Archivo de acta.',
  `last_update` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la última actualización del ingreso.',
  `flag_aviso_fd` tinyint(1) DEFAULT NULL COMMENT 'Indica si el ingreso fue avisado (1 si fue avisado, 0 no NULL si no lo fue).',
  `flag_composito_lab` tinyint(1) DEFAULT NULL COMMENT 'Indica si el ingreso pertenece al laboratorio de composito.',
  `fh_preparacion_c` datetime DEFAULT NULL COMMENT 'Fecha y hora de preparación.',
  `preparador` varchar(200) DEFAULT NULL COMMENT 'Nombre del preparador.',
  `cantEnvases` int(5) DEFAULT NULL COMMENT 'Cantidad de envases del ingreso.',
  `nro_carpeta_snp` varchar(100) DEFAULT NULL COMMENT 'Número de carpeta Sernapesca.',
  `inspector_snp` varchar(100) DEFAULT NULL COMMENT 'Nombre del inspector Sernapesca.',
  `f_envio_mts` date DEFAULT NULL COMMENT 'Fecha de envío.',
  `fecha_publicacion` datetime DEFAULT NULL,
  PRIMARY KEY (`id_ingreso`),
  KEY `id_cliente` (`id_cliente`) USING BTREE,
  KEY `id_dep` (`id_dependencia`) USING BTREE,
  KEY `nro_env1` (`nro_envio1`) USING BTREE,
  KEY `nro_env2` (`nro_envio2`) USING BTREE,
  KEY `idIng` (`id_ingreso`) USING BTREE,
  KEY `idting` (`id_tipo_ingreso`) USING BTREE,
  KEY `idm1` (`id_muestreador`) USING BTREE,
  KEY `idm2` (`id_muestreador2`) USING BTREE,
  KEY `i_entr` (`cod_entrega`) USING BTREE,
  CONSTRAINT `fk_ing_cli` FOREIGN KEY (`id_cliente`) REFERENCES `clientes` (`id_cliente`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ing_dep` FOREIGN KEY (`id_dependencia`) REFERENCES `dependencias` (`id_dependencia`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ting_ing` FOREIGN KEY (`id_tipo_ingreso`) REFERENCES `tipos_ingresos` (`id_tipo_ingreso`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=51996 DEFAULT CHARSET=utf8 COMMENT='Ingresos registrados en el sistema.';

-- ----------------------------
-- Table structure for muestras
-- ----------------------------
DROP TABLE IF EXISTS `muestras`;
CREATE TABLE `muestras` (
  `id_muestra` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `identificacion` int(11) DEFAULT NULL COMMENT 'Identificiación de la muestra.',
  `duplicado` char(1) DEFAULT NULL COMMENT 'Indica si la muestra tiene un duplicado.',
  `material_id` char(2) DEFAULT NULL COMMENT 'Sigla del material de la muestra.',
  `id_ingreso` int(11) NOT NULL COMMENT 'Identificador del ingreso al que pertenece la muestra (tabla "ingresos").',
  `id_tipo_muestra` int(11) NOT NULL COMMENT 'Identificador del tipo de muestra (tabla "tipos_muestras").',
  `clave` varchar(50) DEFAULT NULL COMMENT 'Clave de la muestra.',
  `cod_submuestra` int(6) DEFAULT NULL COMMENT 'Código de la submuestra asociada (dominio SIS_SUBMUE).',
  `id_desc_prod` int(6) DEFAULT NULL COMMENT 'Identificador de la descripción del producto (tabla "descripcion_prod").',
  `descripcion_muestra` varchar(500) DEFAULT NULL COMMENT 'Descripción de la muestra.',
  `cod_especie` int(6) DEFAULT NULL COMMENT 'Código de la especie asociada a la muestra (dominio SIS_ESPECI).',
  `t_ingreso` varchar(20) DEFAULT NULL COMMENT 'Temperatura de ingreso.',
  `t_ingreso_error` varchar(5) DEFAULT NULL COMMENT 'Error de la temperatura de ingreso.',
  `t_corregida` varchar(5) DEFAULT NULL COMMENT 'Temperatura corregida.',
  `id_termometro` int(6) DEFAULT NULL COMMENT 'Código del termómetro utilizado (dominio SIS_TERMOM).',
  `vol_ingreso` varchar(7) DEFAULT NULL COMMENT 'Volumen de ingreso.',
  `ph_ingreso` decimal(5,0) DEFAULT NULL COMMENT 'PH de ingreso.',
  `flag_primario` char(1) DEFAULT NULL,
  `flag_secundario` char(1) DEFAULT NULL,
  `flag_refrigeracion` char(1) DEFAULT NULL,
  `cant_refrigerante` int(3) DEFAULT NULL COMMENT 'Cantidad de refrigerante utilizado en la muestra.',
  `flag_condicion` char(1) DEFAULT NULL,
  `flag_identificacion` char(1) DEFAULT NULL,
  `flag_testigo` char(1) DEFAULT NULL,
  `flag_tmuestra` char(1) DEFAULT NULL,
  `flag_nmuestras` char(1) DEFAULT NULL,
  `flag_descripcion` char(1) DEFAULT NULL,
  `flag_especie` char(1) DEFAULT NULL,
  `flag_aceptado` char(1) DEFAULT NULL,
  `estado_v` char(1) DEFAULT NULL,
  `cod_val_resultados` int(6) DEFAULT NULL COMMENT 'Código de la validación de la muestra (dominio SIS_VALIDA).',
  `n_muestras` int(3) DEFAULT NULL COMMENT 'Número de muestras.',
  `obs_verificacion` varchar(5000) DEFAULT NULL COMMENT 'Observaciones de la verificación.',
  `fh_verificacion` datetime DEFAULT NULL COMMENT 'Fecha y hora de verificación de la muestra.',
  `idus_verificacion` int(11) DEFAULT NULL COMMENT 'Identificador del usuario verificador de la muestra (tabla "usuarios").',
  `foto` varchar(500) DEFAULT NULL COMMENT 'Fotografía de la muestra.',
  `fecha_foto` varchar(500) DEFAULT NULL COMMENT 'Fecha de registro de la fotografía de la muestra.',
  `hora_caudal` time DEFAULT NULL COMMENT 'Hora en que se midió el caudal de la muestra.',
  `caudal` varchar(20) DEFAULT NULL COMMENT 'Caudal de la muestra.',
  `formato_in` char(2) DEFAULT NULL COMMENT 'Sigla del formato de ingreso.',
  `fecha_faena` varchar(50) DEFAULT NULL COMMENT 'Fecha del faenamiento (carnes).',
  `fecha_elaboracion` varchar(100) DEFAULT NULL COMMENT 'Fecha de elaboración del producto asociado a la muestra.',
  `fecha_vencimiento` varchar(50) DEFAULT NULL COMMENT 'Fecha de vencimiento del producto asociado a la muestra.',
  `temp_muestreo` varchar(10) DEFAULT NULL COMMENT 'Temperatura de muestreo.',
  `frigorifico` varchar(200) DEFAULT NULL COMMENT 'Frigorífico donde se obtuvo la muestra (carnes).',
  `cod_establecimiento` varchar(100) DEFAULT NULL COMMENT 'Código del establecimiento donde se obtuvo la muestra.',
  `pais_origen` varchar(100) DEFAULT NULL COMMENT 'País de origen de la muestra.',
  `n_cortes` varchar(50) DEFAULT NULL COMMENT 'Número de cortes de la muestra.',
  `n_cajas` varchar(50) DEFAULT NULL COMMENT 'Número de cajas de la muestra.',
  `lote` varchar(100) DEFAULT NULL COMMENT 'Número de lote de la muestra.',
  `datos_camion` varchar(100) DEFAULT NULL COMMENT 'Datos del camión utilizado en el muestreo.',
  `flag_composito` char(1) DEFAULT NULL,
  `contacto_manip` varchar(20) DEFAULT NULL COMMENT 'Indica el nivel de contacto del manipulador con la muestra.',
  `actividad_manip` varchar(200) DEFAULT NULL COMMENT 'Actividad desempañada por el manipulador.',
  `seccion_manip` varchar(200) DEFAULT NULL COMMENT 'Sección en la que se desempeña el manipulador.',
  `sala_manip` varchar(20) DEFAULT NULL COMMENT 'Sala en que se realizó la manipulación.',
  `flag_cuadrante` char(1) DEFAULT NULL COMMENT 'Indica si la muestra está asociada a un cuadrante (1 si está asociada, 0 o NULL si no lo está).',
  `cod_cuadrante` int(11) DEFAULT NULL COMMENT 'Código del cuadrante asociado a la muestra (dominio SIS_CUADRA).',
  `cod_regionh` int(6) DEFAULT NULL COMMENT 'Código de la región asociada a la muestra (dominio SIS_REGION).',
  `cod_etapah` int(6) DEFAULT NULL COMMENT 'Código de la etapa asociada a la muestra (dominio SIS_ETAPAS).',
  `cod_consumoh` int(6) DEFAULT NULL COMMENT 'Código del consumo asociado a la muestra (dominio SIS_FORCON).',
  `cod_tarroh` int(6) DEFAULT NULL COMMENT 'Código del tarro asociado a la muestra (dominio SIS_TARROS).',
  `cod_peso_exph` int(6) DEFAULT NULL COMMENT 'Código del peso asociado a la muestra (dominio SIS_PESOEX).',
  `cod_psmbh` int(6) DEFAULT NULL COMMENT 'Código de PSMB (dominio SIS_PSMB).',
  `cod_excepcionh` int(6) DEFAULT NULL COMMENT 'Código de la excepción asociada a la muestra (dominio SIS_EXCEPC).',
  `flag_acta` tinyint(1) DEFAULT NULL,
  `last_update` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la última actualización de la muestra.',
  PRIMARY KEY (`id_muestra`),
  KEY `id_ingreso` (`id_ingreso`) USING BTREE,
  KEY `id_tipo_muestra` (`id_tipo_muestra`) USING BTREE,
  KEY `desc_muestra` (`descripcion_muestra`(255)) USING BTREE,
  KEY `i_cod_norma_val` (`cod_val_resultados`) USING BTREE,
  KEY `i_mat` (`material_id`) USING BTREE,
  CONSTRAINT `fk_tmuestr_muest` FOREIGN KEY (`id_tipo_muestra`) REFERENCES `tipos_muestras` (`id_tipo_muestra`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `muestras_ibfk_1` FOREIGN KEY (`id_ingreso`) REFERENCES `ingresos` (`id_ingreso`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=609126 DEFAULT CHARSET=utf8 COMMENT='Registro de las muestras efectuadas, junto con sus atributos.';

-- ----------------------------
-- Table structure for reclamos
-- ----------------------------
DROP TABLE IF EXISTS `reclamos`;
CREATE TABLE `reclamos` (
  `id_reclamo` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `id_contacto_tecnico` int(11) DEFAULT NULL COMMENT 'Identificador del contacto técnico (tabla "contactos_tecnicos").',
  `ext_nombre` varchar(100) DEFAULT NULL COMMENT 'Nombre de la persona registradora del reclamo, en caso de que no sea un contacto técnico.',
  `ext_mail` varchar(100) DEFAULT NULL COMMENT 'Correo electrónico de la persona registradora del reclamo, en caso de que no sea un contacto técnico.',
  `deteccion` enum('Externa','Interna') NOT NULL COMMENT 'Indica si la detección del reclamo es externa o interna (posibles valores: "Externa", "Interna").',
  `area` varchar(500) DEFAULT NULL COMMENT 'Área del reclamo.',
  `descripcion` text COMMENT 'Descripción del reclamo.',
  `id_ingreso_implicado` int(11) DEFAULT NULL COMMENT 'Identificador el ingreso implicado en el reclamo (tabla "ingresos").',
  `fh_abierto` datetime DEFAULT NULL COMMENT 'Fecha y hora de registro del reclamo',
  `fh_cierre` datetime DEFAULT NULL COMMENT 'Fecha y hora de cierre del reclamo.',
  `flag_aviso_cl` tinyint(1) DEFAULT NULL COMMENT 'Indica si se ha notificado al cliente de la recepción del reclamo (1 si fue avisado, 0 o NULL si no lo fue).',
  `flag_justificado` tinyint(1) DEFAULT NULL COMMENT 'Indica si el reclamo está justificado (1 si fue justificado, 0 o NULL si no lo fue).',
  `justificacion` text COMMENT 'Justificación del reclamo.',
  `flag_implicancias` tinyint(1) DEFAULT NULL COMMENT 'Indica si el reclamo conlleva alguna implicancia (1 si conlleva, 0 o NULL si no conlleva).',
  `fecha_tnc` date DEFAULT NULL COMMENT 'Fecha de ocurrencia del trabajo no conforme.',
  `just_implicancia` text COMMENT 'Justificación de las implicancias asociadas al reclamo.',
  `flag_ea` tinyint(1) DEFAULT NULL COMMENT 'Indica si el reclamo esta asociado al área de análisis (1 si lo está, 0 o NULL si no lo está).',
  `flag_oi` tinyint(1) DEFAULT NULL COMMENT 'Indica si el reclamo está asociado a Sernapesca (1 si lo está, 0 o NULL si no lo está).',
  `fecha_aviso_oi` date DEFAULT NULL COMMENT 'Fecha de aviso a Sernapesca.',
  `id_ingreso_corregido` int(11) DEFAULT NULL COMMENT 'Identificador del ingreso corregido (tabla "ingresos").',
  `fecha_carta` date DEFAULT NULL COMMENT 'Fecha de envío de la carta como respuesta al reclamo.',
  `fecha_mail` date DEFAULT NULL COMMENT 'Fecha de envío del correo electrónico como respuesta al reclamo.',
  `participantes` text COMMENT 'Siglas de los participantes del reclamo.',
  `estado` char(1) DEFAULT NULL COMMENT 'Estado del reclamo.',
  `observaciones` text COMMENT 'Observaciones del reclamo.',
  `flag_eliminado` tinyint(1) DEFAULT NULL COMMENT 'Indica si el reclamo está eliminado (1 si lo está, 0 o NULL si no lo está).',
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id_reclamo`),
  KEY `fk_id_cont_tec_1` (`id_contacto_tecnico`),
  CONSTRAINT `fk_id_cont_tec_1` FOREIGN KEY (`id_contacto_tecnico`) REFERENCES `contactos_dependencias` (`id_contacto_tecnico`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=178 DEFAULT CHARSET=latin1 COMMENT='Historial de reclamos registrados por los contactos técnicos.';

-- ----------------------------
-- Table structure for tipos_analisis
-- ----------------------------
DROP TABLE IF EXISTS `tipos_analisis`;
CREATE TABLE `tipos_analisis` (
  `id_tipo_analisis` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `id_ta_padre` int(11) DEFAULT NULL COMMENT 'Identificador del tipo de análisis padre (tabla "tipos_analisis").',
  `version` int(3) DEFAULT NULL COMMENT 'Versión del tipo de análisis.',
  `id_tipo_ingreso` int(11) DEFAULT NULL COMMENT 'Identificador del tipo de ingreso (tabla "tipos_ingresos").',
  `id_tipo_muestra` int(11) NOT NULL COMMENT 'Identificador del tipo de muestra (tabla "tipos_muestras").',
  `id_envase` int(11) DEFAULT NULL COMMENT 'Indentificador del envase asociado al tipo de análisis (tabla "envases").',
  `cod_area` int(6) NOT NULL COMMENT 'Código del área del tipo de análisis (dominio SIS_AREASA).',
  `nombre` varchar(100) NOT NULL COMMENT 'Nombre del tipo de análisis.',
  `name` varchar(100) DEFAULT NULL COMMENT 'Nombre del tipo de análisis (inglés).',
  `cod_tecnica` int(6) DEFAULT NULL COMMENT 'Código del método de análisis (dominio SIS_METODO).',
  `cod_acreditacion` varchar(1000) DEFAULT NULL COMMENT 'Código de acreditación (dominio SIS_ACREDITA).',
  `norma` varchar(1000) DEFAULT NULL COMMENT 'Norma asociada al tipo de análisis.',
  `tiempo_max` varchar(10) DEFAULT NULL COMMENT 'Tiempo máximo del tipo de análisis.',
  `vol_muestra` varchar(50) DEFAULT NULL COMMENT 'Volumen de la muestra asociada.',
  `cod_unidad` int(6) DEFAULT NULL COMMENT 'Código de la unidad de medida del tipo de análisis (dominio SIS_UNIMED).',
  `lim_deteccion` varchar(100) DEFAULT NULL COMMENT 'Límite de detección del tipo de análisis.',
  `lim_cuantificacion` varchar(100) DEFAULT NULL COMMENT 'Límite de cuantificación.',
  `flag_vigente` tinyint(1) DEFAULT NULL COMMENT 'Indica si el tipo de análisis se encuentra vigente (1 si lo está, 0 o NULL si no lo está).',
  `acred_muestreo` int(11) DEFAULT NULL COMMENT 'Identificador de la acreditación del muestreo (tabla "acre_muestreo").',
  `flag_cartacontrol` tinyint(1) DEFAULT NULL COMMENT 'Indica si el tipo de análisis posee carta de control (1 si la posee, 0 o NULL si no la posee).',
  `id_usuario_upin` int(6) DEFAULT NULL COMMENT 'Identificador del usuario que registró el tipo de análisis (tabla "usuarios").',
  `id_usuario_vali` int(6) DEFAULT NULL COMMENT 'Identificador del usuario validador del tipo de análisis (tabla "usuarios").',
  `flag_eliminado` tinyint(1) DEFAULT NULL COMMENT 'Indica si el tipo de análisis está eliminado (1 si lo está, 0 o NULL si no lo está).',
  `id_usuario_elim` int(6) DEFAULT NULL COMMENT 'Identificador del usuario eliminador del tipo de análisis (tabla "usuarios").',
  `id_usuario_conf` int(6) DEFAULT NULL COMMENT 'Identificador del usuario configurador del tipo de análisis (tabla "usuarios").',
  `estado` char(1) DEFAULT NULL COMMENT 'Sigla del estado del tipo de análisis.',
  `update_timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima actualización del tipo de análisis.',
  PRIMARY KEY (`id_tipo_analisis`)
) ENGINE=InnoDB AUTO_INCREMENT=13309 DEFAULT CHARSET=utf8 COMMENT='Tipos de análisis registrados en el sistema.';

-- ----------------------------
-- Table structure for tipos_ingresos
-- ----------------------------
DROP TABLE IF EXISTS `tipos_ingresos`;
CREATE TABLE `tipos_ingresos` (
  `id_tipo_ingreso` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `descripcion` varchar(100) DEFAULT NULL COMMENT 'Descripción del tipo de ingreso.',
  `obs` varchar(100) DEFAULT NULL COMMENT 'Observación al tipo de ingreso.',
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id_tipo_ingreso`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='Tipos de ingresos registrados en el sistema.';

-- ----------------------------
-- Table structure for tipos_muestras
-- ----------------------------
DROP TABLE IF EXISTS `tipos_muestras`;
CREATE TABLE `tipos_muestras` (
  `id_tipo_muestra` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Clave primaria.',
  `id_tipo_ingreso` int(11) NOT NULL COMMENT 'Identificador del tipo de ingreso (tabla "tipos_ingresos").',
  `item` varchar(50) DEFAULT NULL COMMENT 'Número de ítem asociado al tipo de muestra.',
  `ABR` char(3) DEFAULT NULL COMMENT 'Abreviación del tipo de muestra.',
  `descripcion` varchar(1000) NOT NULL COMMENT 'Descripción del tipo de muestra.',
  `matriz` int(6) DEFAULT NULL COMMENT 'Matriz a la que el tipo de muestra está asociada (dominio SIS_MATRIZ).',
  `des_primario` varchar(1000) DEFAULT NULL COMMENT 'Descripcion del envase primario.',
  `des_secundario` varchar(1000) DEFAULT NULL COMMENT 'Descripción del envase secundario.',
  `des_refrigeracion` varchar(1000) DEFAULT NULL COMMENT 'Descripción de la refrigeración.',
  `cant_refrigerante` varchar(50) DEFAULT NULL COMMENT 'Cantidad de refrigerante.',
  `des_condicion` varchar(1000) DEFAULT NULL COMMENT 'Descripción de la condición del tipo de muestra.',
  `des_identificacion` varchar(1000) DEFAULT NULL COMMENT 'Descripción del mecanismo de identificación del tipo de muestra.',
  `des_ttraslado` varchar(1000) DEFAULT NULL COMMENT 'Temperatura de traslado del tipo de muestra.',
  `des_temperatura` varchar(1000) DEFAULT NULL,
  `des_testigo` varchar(1000) DEFAULT NULL COMMENT 'Descripción del testigo del tipo de muestra.',
  `obs` varchar(100) DEFAULT NULL COMMENT 'Observación del tipo de muestra.',
  `flag_activo` tinyint(1) DEFAULT NULL COMMENT 'Indica si el tipo de muestra se encuentra activo (1 si lo está, 0 o NULL si no lo está).',
  `estado_materia` enum('LÃ­quido','SÃ³lido','TÃ³rula','Placa','Esponja') DEFAULT NULL COMMENT 'Estado de la materia del tipo de muestra (posibles valores: "Líquido", "Sólido", "Tórula", "Placa", "Esponja").',
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id_tipo_muestra`),
  KEY `idtin` (`id_tipo_ingreso`) USING BTREE,
  KEY `mat` (`matriz`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=716 DEFAULT CHARSET=utf8 COMMENT='Tipos de muestras registrados en el sistema.';

-- ----------------------------
-- Procedure structure for insStage_analisis
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_analisis`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_analisis`(IN `fecha1` datetime,IN `fecha2` datetime)
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.analisis;
INSERT INTO biripit_stage_dw_silob.analisis (id_analisis,id_tipo_analisis,variacion,id_muestra,cod_norma_val,
cod_unidad,cod_acreditacion,id_envase,id_set,id_cartacontrol,last_update)
SELECT
	ana.id_analisis,ana.id_tipo_analisis,ana.variacion,ana.id_muestra,ana.cod_norma_val,
ana.cod_unidad,ana.cod_acreditacion,ana.id_envase,ana.id_set,ana.id_cartacontrol,ana.last_update
FROM
	biripit_dw_contingencia.ingresos ing
INNER JOIN biripit_dw_contingencia.informes_clientes inf ON inf.id_ingreso = ing.id_ingreso
INNER JOIN biripit_dw_contingencia.muestras mu ON mu.id_ingreso = ing.id_ingreso
INNER JOIN biripit_dw_contingencia.analisis ana ON ana.id_muestra = mu.id_muestra
WHERE
	inf.tipo_doc = 'informe'
AND inf.id_ingreso IS NOT NULL
AND inf.id_ingreso != 0
AND inf.fecha_publicacion BETWEEN fecha1 AND fecha2 
GROUP BY ana.id_analisis;
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insStage_clientes
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_clientes`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_clientes`(IN `fecha1` timestamp,IN `fecha2` timestamp)
BEGIN
	SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.clientes;
INSERT INTO biripit_stage_dw_silob.clientes (id_cliente,razon_social,nombre,nro_rut,dv_rut,direccion,cont_facturacion,fono_cont,
fono2_cont,mail_cont,cod_ciiu,cod_status,pub_local,pub_descrip,pub_fecham,estado_cl,version,flag_vigente,id_usuario_upin,
id_usuario_vali,update_timestamp,flag_eliminado)
SELECT 
cl.id_cliente,cl.razon_social,cl.nombre,cl.nro_rut,cl.dv_rut,cl.direccion,cl.cont_facturacion,cl.fono_cont,
cl.fono2_cont,cl.mail_cont,cl.cod_ciiu,cl.cod_status,cl.pub_local,cl.pub_descrip,cl.pub_fecham,cl.estado_cl,
cl.version,cl.flag_vigente,cl.id_usuario_upin,cl.id_usuario_vali,cl.update_timestamp,cl.flag_eliminado
FROM biripit_dw_contingencia.clientes cl
WHERE cl.update_timestamp BETWEEN fecha1 AND fecha2 ;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insStage_codigosG
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_codigosG`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_codigosG`(IN `fecha1` datetime,IN `fecha2` datetime)
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.codigos_g;
INSERT INTO biripit_stage_dw_silob.codigos_g (id_codigo_g,cod_tabla,descripcion,atributo,atributo2,
orden_campo,flag_vig,id_usuario_r,last_update)
SELECT 
cg.id_codigo_g,cg.cod_tabla,cg.descripcion,cg.atributo,cg.atributo2,cg.orden_campo,cg.flag_vig,cg.id_usuario_r,cg.last_update
FROM biripit_dw_contingencia.codigos_g cg WHERE cg.cod_tabla='SIS_AREACC' AND cg.last_update BETWEEN fecha1 AND fecha2;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insStage_contactos_dependencias
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_contactos_dependencias`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_contactos_dependencias`(IN `fecha1` datetime,IN `fecha2` datetime)
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.contactos_dependencias;
INSERT INTO biripit_stage_dw_silob.contactos_dependencias (id_con_dep,id_contacto_tecnico,id_dependencia,
fecha_reg,id_usuario,flag_vigente,last_update)
SELECT 
cd.id_con_dep,cd.id_contacto_tecnico,cd.id_dependencia,cd.fecha_reg,cd.id_usuario,cd.flag_vigente,cd.last_update
FROM biripit_dw_contingencia.contactos_dependencias cd
WHERE cd.last_update BETWEEN fecha1 AND fecha2;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insStage_contactos_tecnicos
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_contactos_tecnicos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_contactos_tecnicos`(IN `fecha1` datetime,IN `fecha2` datetime)
BEGIN
	SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.contactos_tecnicos;
INSERT INTO biripit_stage_dw_silob.contactos_tecnicos (id_contacto_tecnico,id_dependencia,nombre,nro_rut,
cod_cargo,fono_1,fono_2,mail,nombre_usuario,pass,flag_activo,cod_coordinador,last_update)
SELECT 
ct.id_contacto_tecnico,ct.id_dependencia,ct.nombre,ct.nro_rut,
ct.cod_cargo,ct.fono_1,ct.fono_2,ct.mail,ct.nombre_usuario,ct.pass,flag_activo,ct.cod_coordinador,ct.last_update
FROM biripit_dw_contingencia.contactos_tecnicos ct 
WHERE ct.last_update BETWEEN fecha1 AND fecha2;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insStage_dependencias
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_dependencias`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_dependencias`(IN `fecha1` datetime,IN `fecha2` datetime)
BEGIN
	SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.dependencias;
INSERT INTO biripit_stage_dw_silob.dependencias (id_dependencia,id_cliente,nombre,direccion,gerencia,flag_activo,
version,estado_dep,id_usuario_upin,id_usuario_vali,fh_update)
SELECT 
dep.id_dependencia,dep.id_cliente,dep.nombre,dep.direccion,dep.gerencia,dep.flag_activo,
dep.version,dep.estado_dep,dep.id_usuario_upin,dep.id_usuario_vali,dep.fh_update
FROM biripit_dw_contingencia.dependencias dep
WHERE dep.fh_update BETWEEN fecha1 AND fecha2;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insStage_encuestas
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_encuestas`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_encuestas`(IN `fecha1` datetime,IN `fecha2` datetime)
BEGIN
	SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.encuestas;
INSERT INTO biripit_stage_dw_silob.encuestas (id_encuesta,id_contacto,codigo,fecha,area,flag_muestreo,flag_analisis,
p1,p2,p3,p4,p5,p6,p7,p8,p9,mejora,observacion,last_update)
SELECT 
enc.id_encuesta,enc.id_contacto,enc.codigo,enc.fecha,enc.area,enc.flag_muestreo,enc.flag_analisis,
enc.p1,enc.p2,enc.p3,enc.p4,enc.p5,enc.p6,enc.p7,enc.p8,enc.p9,enc.mejora,enc.observacion,enc.last_update
FROM biripit_dw_contingencia.encuestas enc
WHERE enc.last_update BETWEEN fecha1 AND fecha2;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insStage_ingresos
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_ingresos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_ingresos`(IN `fecha1` timestamp,IN `fecha2` timestamp)
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.ingresos;
INSERT INTO biripit_stage_dw_silob.ingresos(id_ingreso,id_tipo_ingreso,id_cliente,id_dependencia,id_usuario_ingreso,id_usuario_validacion,id_factura,nro_ingreso,
raya,flag_reemplazado,flag_foto_informe,flag_carta,flag_sma,titular_proyecto,rut_titular,representante,rut_representante,proyecto,instrumentos,muestreador,
nro_requerimiento,fh_validacion,fecha_ingreso,hora_ingreso,certificacion_snp,nro_formulario_snp,cod_destino_snp,cod_categoria,lugar_descarga,f_i_muestreo,
f_muestreo,fh_almacenamiento,h_i_muestreo,h_t_muestreo,f_i_verificacion,f_t_verificacion,cont_muestreo,nro_muestreo,id_muestreador,nro_muestreo2,id_muestreador2,
cod_entrega,entidad_m,flag_limites,lugar_muestreo,envases_cliente,coleman_cliente,otros_bienes_cliente,fh_informe,flag_caudal,flag_compuesta,fh_v_destino0,
fh_s_destino0,cod_destino1,fh_i_destino1,fh_s_destino1,cod_destino2,fh_i_destino2,fh_s_destino2,cod_destino3,fh_i_destino3,fh_s_destino3,cod_destino4,
fh_i_destino4,fh_s_destino4,cod_destino5,nro_fact,fh_fact,monto_muestreo,monto_muestreo_oi,monto_analisis,flag_pagado,nro_n_credito,monto_n_credito,
file_cotizacion,transporte_envio1,nro_envio1,transporte_envio2,nro_envio2,persona_retira,contacto_retira,persona_recibe,contacto_recibe,fecha_recibe,
id_us_destino0,id_us_destino1,id_us_destino2,id_us_destino3,id_us_destino4,flag_infact,file_recepcion,estado_caja,medio_transporte,comentarios,cod_informe,
flag_prioritario,abr,flag_estado,flag_avisado,cod_rechazo,file_acta,last_update,flag_aviso_fd,flag_composito_lab,fh_preparacion_c,preparador,cantEnvases,
nro_carpeta_snp,inspector_snp,f_envio_mts,fecha_publicacion)
SELECT
	ing.id_ingreso,
	ing.id_tipo_ingreso,
	ing.id_cliente,
	ing.id_dependencia,
	ing.id_usuario_ingreso,
	ing.id_usuario_validacion,
	ing.id_factura,
	ing.nro_ingreso,
	ing.raya,
	ing.flag_reemplazado,
	ing.flag_foto_informe,
	ing.flag_carta,
	ing.flag_sma,
	ing.titular_proyecto,
	ing.rut_titular,
	ing.representante,
	ing.rut_representante,
	ing.proyecto,
	ing.instrumentos,
	ing.muestreador,
	ing.nro_requerimiento,
	ing.fh_validacion,
	ing.fecha_ingreso,
	ing.hora_ingreso,
	ing.certificacion_snp,
	ing.nro_formulario_snp,
	ing.cod_destino_snp,
	ing.cod_categoria,
	ing.lugar_descarga,
	ing.f_i_muestreo,
	ing.f_muestreo,
	ing.fh_almacenamiento,
	ing.h_i_muestreo,
	ing.h_t_muestreo,
	ing.f_i_verificacion,
	ing.f_t_verificacion,
	ing.cont_muestreo,
	ing.nro_muestreo,
	ing.id_muestreador,
	ing.nro_muestreo2,
	ing.id_muestreador2,
	ing.cod_entrega,
	ing.entidad_m,
	ing.flag_limites,
	ing.lugar_muestreo,
	ing.envases_cliente,
	ing.coleman_cliente,
	ing.otros_bienes_cliente,
	ing.fh_informe,
	ing.flag_caudal,
	ing.flag_compuesta,
	ing.fh_v_destino0,
	ing.fh_s_destino0,
	ing.cod_destino1,
	ing.fh_i_destino1,
	ing.fh_s_destino1,
	ing.cod_destino2,
	ing.fh_i_destino2,
	ing.fh_s_destino2,
	ing.cod_destino3,
	ing.fh_i_destino3,
	ing.fh_s_destino3,
	ing.cod_destino4,
	ing.fh_i_destino4,
	ing.fh_s_destino4,
	ing.cod_destino5,
	ing.nro_fact,
	ing.fh_fact,
	ing.monto_muestreo,
	ing.monto_muestreo_oi,
	ing.monto_analisis,
	ing.flag_pagado,
	ing.nro_n_credito,
	ing.monto_n_credito,
	ing.file_cotizacion,
	ing.transporte_envio1,
	ing.nro_envio1,
	ing.transporte_envio2,
	ing.nro_envio2,
	ing.persona_retira,
	ing.contacto_retira,
	ing.persona_recibe,
	ing.contacto_recibe,
	ing.fecha_recibe,
	ing.id_us_destino0,
	ing.id_us_destino1,
	ing.id_us_destino2,
	ing.id_us_destino3,
	ing.id_us_destino4,
	ing.flag_infact,
	ing.file_recepcion,
	ing.estado_caja,
	ing.medio_transporte,
	ing.comentarios,
	ing.cod_informe,
	ing.flag_prioritario,
	ing.abr,
	ing.flag_estado,
	ing.flag_avisado,
	ing.cod_rechazo,
	ing.file_acta,
	ing.last_update,
	ing.flag_aviso_fd,
	ing.flag_composito_lab,
	ing.fh_preparacion_c,
	ing.preparador,
	ing.cantEnvases,
	ing.nro_carpeta_snp,
	ing.inspector_snp,
	ing.f_envio_mts,
	t1.fecha_publicacion
FROM
	biripit_dw_contingencia.ingresos ing
LEFT JOIN biripit_dw_contingencia.informes_clientes t1 ON t1.id_ingreso = ing.id_ingreso
WHERE
	t1.tipo_doc = 'informe'
AND t1.id_ingreso IS NOT NULL
AND t1.id_ingreso != 0
AND ing.last_update BETWEEN fecha1
AND fecha2 GROUP BY ing.id_ingreso;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insStage_muestras
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_muestras`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_muestras`(IN `fecha1` timestamp,IN `fecha2` timestamp)
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.muestras;
INSERT INTO biripit_stage_dw_silob.muestras(id_muestra,identificacion,duplicado,material_id,id_ingreso,id_tipo_muestra,
clave,cod_submuestra,id_desc_prod,descripcion_muestra,cod_especie,t_ingreso,t_ingreso_error,t_corregida,id_termometro,
vol_ingreso,ph_ingreso,flag_primario,flag_secundario,flag_refrigeracion,cant_refrigerante,flag_condicion,flag_identificacion,
flag_testigo,flag_tmuestra,flag_nmuestras,flag_descripcion,flag_especie,flag_aceptado,estado_v,cod_val_resultados,n_muestras,
obs_verificacion,fh_verificacion,idus_verificacion,foto,fecha_foto,hora_caudal,caudal,formato_in,fecha_faena,fecha_elaboracion,
fecha_vencimiento,temp_muestreo,frigorifico,cod_establecimiento,pais_origen,n_cortes,n_cajas,lote,datos_camion,flag_composito,
contacto_manip,actividad_manip,seccion_manip,sala_manip,flag_cuadrante,cod_cuadrante,cod_regionh,cod_etapah,cod_consumoh,
cod_tarroh,cod_peso_exph,cod_psmbh,cod_excepcionh,flag_acta,last_update)
SELECT 
	mue.id_muestra,
	mue.identificacion,
	mue.duplicado,
	mue.material_id,
	mue.id_ingreso,
	mue.id_tipo_muestra,
	mue.clave,
	mue.cod_submuestra,
	mue.id_desc_prod,
	mue.descripcion_muestra,
	mue.cod_especie,
	mue.t_ingreso,
	mue.t_ingreso_error,
	mue.t_corregida,
	mue.id_termometro,
	mue.vol_ingreso,
	mue.ph_ingreso,
	mue.flag_primario,
	mue.flag_secundario,
	mue.flag_refrigeracion,
	mue.cant_refrigerante,
	mue.flag_condicion,
	mue.flag_identificacion,
	mue.flag_testigo,
	mue.flag_tmuestra,
	mue.flag_nmuestras,
	mue.flag_descripcion,
	mue.flag_especie,
	mue.flag_aceptado,
	mue.estado_v,
	mue.cod_val_resultados,
	mue.n_muestras,
	mue.obs_verificacion,
	mue.fh_verificacion,
	mue.idus_verificacion,
	mue.foto,
	mue.fecha_foto,
	mue.hora_caudal,
	mue.caudal,
	mue.formato_in,
	mue.fecha_faena,
	mue.fecha_elaboracion,
	mue.fecha_vencimiento,
	mue.temp_muestreo,
	mue.frigorifico,
	mue.cod_establecimiento,
	mue.pais_origen,
	mue.n_cortes,
	mue.n_cajas,
	mue.lote,
	mue.datos_camion,
	mue.flag_composito,
	mue.contacto_manip,
	mue.actividad_manip,
	mue.seccion_manip,
	mue.sala_manip,
	mue.flag_cuadrante,
	mue.cod_cuadrante,
	mue.cod_regionh,
	mue.cod_etapah,
	mue.cod_consumoh,
	mue.cod_tarroh,
	mue.cod_peso_exph,
	mue.cod_psmbh,
	mue.cod_excepcionh,
	mue.flag_acta,
	mue.last_update
FROM
	biripit_dw_contingencia.ingresos ing
INNER JOIN biripit_dw_contingencia.informes_clientes t1 ON t1.id_ingreso = ing.id_ingreso
INNER JOIN biripit_dw_contingencia.muestras mue ON mue.id_ingreso = ing.id_ingreso
WHERE
	t1.tipo_doc = 'informe'
AND t1.id_ingreso IS NOT NULL
AND t1.id_ingreso != 0
AND mue.last_update BETWEEN fecha1
AND fecha2 GROUP BY mue.id_muestra;
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insStage_reclamos
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_reclamos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_reclamos`(IN `fecha1` datetime,IN `fecha2` datetime)
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.reclamos;
INSERT INTO biripit_stage_dw_silob.reclamos (id_reclamo,id_contacto_tecnico,ext_nombre,ext_mail,deteccion,area,descripcion,
id_ingreso_implicado,fh_abierto,fh_cierre,flag_aviso_cl,flag_justificado,justificacion,flag_implicancias,fecha_tnc,
just_implicancia,flag_ea,flag_oi,fecha_aviso_oi,id_ingreso_corregido,fecha_carta,fecha_mail,participantes,estado,observaciones,
flag_eliminado,last_update)
SELECT 
rec.id_reclamo,rec.id_contacto_tecnico,rec.ext_nombre,rec.ext_mail,rec.deteccion,rec.area,rec.descripcion,
rec.id_ingreso_implicado,rec.fh_abierto,rec.fh_cierre,rec.flag_aviso_cl,rec.flag_justificado,rec.justificacion,
rec.flag_implicancias,rec.fecha_tnc,rec.just_implicancia,rec.flag_ea,rec.flag_oi,rec.fecha_aviso_oi,rec.id_ingreso_corregido,
rec.fecha_carta,rec.fecha_mail,rec.participantes,rec.estado,rec.observaciones,rec.flag_eliminado,rec.last_update
FROM biripit_dw_contingencia.reclamos rec WHERE rec.fh_cierre IS NOT NULL AND rec.fh_cierre!='0000-00-00'
AND rec.last_update BETWEEN fecha1 AND fecha2;
SET foreign_key_checks = 1;
END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insStage_tipos_ingresos
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_tipos_ingresos`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_tipos_ingresos`(IN `fecha1` datetime,IN `fecha2` datetime)
BEGIN
	SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.tipos_ingresos;
INSERT INTO biripit_stage_dw_silob.tipos_ingresos (id_tipo_ingreso,descripcion,obs,last_update)
SELECT 
ti.id_tipo_ingreso,ti.descripcion,ti.obs,ti.last_update
FROM biripit_dw_contingencia.tipos_ingresos ti
WHERE ti.last_update BETWEEN fecha1 AND fecha2;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insStage_tipos_muestras
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_tipos_muestras`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_tipos_muestras`(IN `fecha1` datetime,IN `fecha2` datetime)
BEGIN
SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.tipos_muestras;
INSERT INTO biripit_stage_dw_silob.tipos_muestras (id_tipo_muestra,id_tipo_ingreso,item,ABR,descripcion,matriz,des_primario,
des_secundario,des_refrigeracion,cant_refrigerante,des_condicion,des_identificacion,des_ttraslado,des_temperatura,
des_testigo,obs,flag_activo,estado_materia,last_update)
SELECT 
tm.id_tipo_muestra,tm.id_tipo_ingreso,tm.item,tm.ABR,tm.descripcion,tm.matriz,tm.des_primario,tm.des_secundario,
tm.des_refrigeracion,tm.cant_refrigerante,tm.des_condicion,tm.des_identificacion,tm.des_ttraslado,tm.des_temperatura,
tm.des_testigo,tm.obs,tm.flag_activo,tm.estado_materia,tm.last_update
FROM biripit_dw_contingencia.tipos_muestras tm
WHERE tm.last_update BETWEEN fecha1 AND fecha2;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;

-- ----------------------------
-- Procedure structure for insStage_tiposAnalisis
-- ----------------------------
DROP PROCEDURE IF EXISTS `insStage_tiposAnalisis`;
DELIMITER ;;
CREATE DEFINER=`biripit_dw`@`%` PROCEDURE `insStage_tiposAnalisis`(IN `fecha1` timestamp,IN `fecha2` timestamp)
BEGIN
	SET foreign_key_checks = 0;
truncate table biripit_stage_dw_silob.tipos_analisis;
INSERT INTO biripit_stage_dw_silob.tipos_analisis (id_tipo_analisis,id_ta_padre,version,id_tipo_ingreso,id_tipo_muestra,
id_envase,cod_area,nombre,name,cod_tecnica,cod_acreditacion,norma,tiempo_max,vol_muestra,cod_unidad,lim_deteccion,
lim_cuantificacion,flag_vigente,acred_muestreo,flag_cartacontrol,id_usuario_upin,id_usuario_vali,flag_eliminado,
id_usuario_elim,id_usuario_conf,estado,update_timestamp)
SELECT 
ta.id_tipo_analisis,ta.id_ta_padre,ta.version,ta.id_tipo_ingreso,ta.id_tipo_muestra,
ta.id_envase,ta.cod_area,ta.nombre,ta.name,ta.cod_tecnica,ta.cod_acreditacion,ta.norma,ta.tiempo_max,ta.vol_muestra,
ta.cod_unidad,ta.lim_deteccion,ta.lim_cuantificacion,ta.flag_vigente,ta.acred_muestreo,ta.flag_cartacontrol,
ta.id_usuario_upin,ta.id_usuario_vali,ta.flag_eliminado,ta.id_usuario_elim,ta.id_usuario_conf,ta.estado,ta.update_timestamp
FROM biripit_dw_contingencia.tipos_analisis ta
WHERE ta.update_timestamp BETWEEN fecha1
AND fecha2 ;
SET foreign_key_checks = 1;

END
;;
DELIMITER ;
