<?php
	/*analisis*/
	function obt_analisis($mysqli,$mysqli2,$error){
		$sql = $mysqli->prepare("
			SELECT 
				IF(ana.id_analisis IS NULL,null,ana.id_analisis),
				IF(ana.id_tipo_analisis IS NULL,null,ana.id_tipo_analisis),
				IF(ana.variacion IS NULL,null,ana.variacion),
				IF(ana.id_muestra IS NULL,null,ana.id_muestra),
				IF(ana.cod_norma_val IS NULL,null,ana.cod_norma_val),
				IF(ana.cod_unidad IS NULL,null,ana.cod_unidad),
				IF(ana.cod_acreditacion IS NULL,null,ana.cod_acreditacion),
				IF(ana.id_envase IS NULL,null,ana.id_envase),
				IF(ana.id_set IS NULL,null,ana.id_set),
				IF(ana.id_cartacontrol IS NULL,null,ana.id_cartacontrol),
				IF(ana.lastupdate IS NULL,null,ana.lastupdate)
			FROM
				ingresos ing
			INNER JOIN informes_clientes inf ON inf.id_ingreso = ing.id_ingreso
			INNER JOIN muestras mu ON mu.id_ingreso = ing.id_ingreso
			INNER JOIN analisis ana ON ana.id_muestra = mu.id_muestra
			WHERE
				inf.tipo_doc = 'informe'
			AND inf.id_ingreso IS NOT NULL
			AND inf.id_ingreso != 0
			AND inf.fecha_publicacion >= '2017-01-01' 
			GROUP BY ana.id_analisis");
		$sql->bind_result($id_analisis,$id_tipo_analisis,$variacion,$id_muestra,$cod_norma_val,$cod_unidad,$cod_acreditacion,$id_envase,$id_set,$id_cartacontrol,$lastupdate);
		$sql->execute();
		$sql->store_result();
		$valores = array();
		while($sql->fetch()){
			$actual = array();
			
			$id_analisis=(strcmp($id_analisis,'')==0)?'null':$mysqli->real_escape_string($id_analisis);
			$id_tipo_analisis=(strcmp($id_tipo_analisis,'')==0)?'null':$mysqli->real_escape_string($id_tipo_analisis);
			$variacion=(strcmp($variacion,'')==0)?'null':"'".$mysqli->real_escape_string($variacion)."'";
			$id_muestra=(strcmp($id_muestra,'')==0)?'null':$mysqli->real_escape_string($id_muestra);
			$cod_norma_val=(strcmp($cod_norma_val,'')==0)?'null':$mysqli->real_escape_string($cod_norma_val);
			$cod_unidad=(strcmp($cod_unidad,'')==0)?'null':$mysqli->real_escape_string($cod_unidad);
			$cod_acreditacion=(strcmp($cod_acreditacion,'')==0)?'null':$mysqli->real_escape_string($cod_acreditacion);
			$id_envase=(strcmp($id_envase,'')==0)?'null':$mysqli->real_escape_string($id_envase);
			$id_set=(strcmp($id_set,'')==0)?'null':$mysqli->real_escape_string($id_set);
			$id_cartacontrol=(strcmp($id_cartacontrol,'')==0)?'null':$mysqli->real_escape_string($id_cartacontrol);
			$lastupdate=(strcmp($lastupdate,'')==0)?'null':"'".$mysqli->real_escape_string($lastupdate)."'";
			
			array_push($actual,$id_analisis,$id_tipo_analisis,$variacion,$id_muestra,$cod_norma_val,$cod_unidad,$cod_acreditacion,$id_envase,$id_set,$id_cartacontrol,$lastupdate);
			array_push($valores,"(".implode(",",$actual).")");
		}
		$str = implode(",",$valores);
		$error = analisis($str,$mysqli2,$error);
		return $error;
	}
	
	function analisis($str,$mysqli2,$error){
		$mysqli2->query("SET foreign_key_checks = 0");
		$mysqli2->query("TRUNCATE TABLE analisis");
		if(strcmp($str,'')!=0){
			
			$consulta = "INSERT INTO analisis(id_analisis,id_tipo_analisis,variacion,id_muestra,cod_norma_val,cod_unidad,cod_acreditacion,id_envase,id_set,id_cartacontrol,last_update) VALUES $str";
			$result = $mysqli2->query($consulta);
			if(!$result) $error = "analisis: ".$mysqli2->error;
		}
		return $error;
	}
?>