<?php
	/*Primera carga: en teoria este codigo solo se ejecuta una vez, pero queda guardado en caso de 
	surgir algun problema en que halla que cargar todo desde 0*/
	require_once("func_actualizacion_resumen.php");
	function transform($mysqli){
		procedimientos_grupo1($mysqli);
		procedimientos_grupo2($mysqli);
		procedimientos_grupo3($mysqli);
	}
	function procedimientos_grupo1($mysqli){
		/*
			documentacion interna: 
			---------------------
			tipos_ingresos proc: complete/InsertCompleteTiposIngresos() realizado
			tipos_muestras proc: complete/InsertCompleteTiposMuestras() realizado
			tipos_analisis proc: complete/InsertCompleteTiposAnalisis()	realizado
			cliente		   proc: complete/InsertCompleteClientes()		realizado
			dependencias   proc: complete/InsertCompleteDependencias()	realizado
			areas          proc: complete/InsertCompleteAreas()			realizado
		*/
		$mysqli->query("CALL InsertCompleteTiposIngresos()");
		$mysqli->query("CALL InsertCompleteTiposMuestras()");
		$mysqli->query("CALL InsertCompleteTiposAnalisis()");
		$mysqli->query("CALL InsertCompleteClientes()");
		$mysqli->query("CALL InsertCompleteDependencias()");
		$mysqli->query("CALL InsertCompleteAreas()");
	}
	function procedimientos_grupo2($mysqli){
		/*
			documentacion interna: 
			---------------------
			ingresos  proc: complete/InsertCompleteIngresos()	realizado
			muestras  proc: complete/InsertCompleteMuestras()	realizado
			analisis  proc: complete/InsertCompleteAnalisis()	realizado
			reclamos  proc: complete/insertCompleteReclamos()	realizado
		    preguntas func: realizado
			encuestas func: realizado
		*/
		$mysqli->query("CALL InsertCompleteIngresos()");
		$mysqli->query("CALL InsertCompleteMuestras()");
		$mysqli->query("CALL InsertCompleteAnalisis()");
		$mysqli->query("CALL insertCompleteReclamos()");
		cargar_preguntas($mysqli);
		cargar_encuestas($mysqli);
		
	}
	function procedimientos_grupo3($mysqli){
		/*
			documentacion interna:
			---------------------
			resumen_mensual_ingresos  proc: complete/insCompleteResIngresos()	realizado
			resumen_mensual_reclamos  proc: complete/insCompleteResReclamos()	realizado
			resumen_mensual_encuestas proc: complete/insCompleteResEncuestas()	no realizado
		*/
		resumen_mensual_ingresos($mysqli);
		resumen_mensual_reclamos($mysqli);
		resumen_mensual_encuestas($mysqli);
	}

	function resumen_mensual_ingresos($mysqli){
		$mysqli->query("CALL insCompleteResIngresos()");
		/*rellenamos los campos faltantes de la tabla de resumen*/
		$resumen = new resumen_ingresos();
		$resumen->cantidad_ingresos($mysqli);
		$resumen->cantidad_muestras($mysqli);
		$resumen->cantidad_analisis($mysqli);
		$resumen->cantidad_informes_corregidos($mysqli);
		
		/*
			transapasamos informacion relevante a las tablas pertinentes
			------------------------------------------------------------
			analisis proc: resumen/modResAnalisis()	realizado
		*/
		$mysqli->query("CALL modResAnalisis()");
	}
	function resumen_mensual_reclamos($mysqli){
		$mysqli->query("CALL insCompleteResReclamos()");
		/*
			transapasamos informacion relevante a las tablas pertinentes
			------------------------------------------------------------
			reclamos proc: resumen/modResReclamos()	realizado
		*/
		$mysqli->query("CALL modResReclamos()");
	}
	function resumen_mensual_encuestas($mysqli){
		$mysqli->query("CALL insResCompleteEncuestas()");
		/*
			transapasamos informacion relevante a las tablas pertinentes
			------------------------------------------------------------
			reclamos proc: resumen/modResReclamos()	realizado
		*/
		modificar_encuestas($mysqli);
		modificar_resumen($mysqli);
	}
	
	function cargar_preguntas($mysqli){
		$consulta= "
			SELECT 
				enc.codigo
			FROM biripit_stage_dw_silob.encuestas enc 
			GROUP BY enc.codigo
		";
		$sql = $mysqli->prepare($consulta);
		$sql->bind_result($codigo);
		$sql->execute();
		$sql->store_result();
		$datos = array();
		$k = 1;
		WHILE($sql->fetch()){
			for($i=1;$i<=9;$i++){
				$array = array();
				$pregunta = "'pregunta[".($i)."]'";
				array_push($array,$k,"'".$codigo."'",$pregunta);
				$str = "(".implode(",",$array).")"; 
				array_push($datos,$str);
				$k++;
			}
		}
		$str = implode(",",$datos);
		$mysqli->query("SET foreign_key_checks = 0");
		$mysqli->query("INSERT INTO PDW_preguntas(id_pregunta,cod_encuesta,pregunta) VALUES $str");
		$sql->close();
	}
	function cargar_encuestas($mysqli){
		$consulta2 = "
				SELECT enc.id_encuesta,enc.id_contacto,enc.codigo,enc.fecha,area,enc.flag_muestreo,enc.flag_analisis,enc.p1,enc.p2,enc.p3,enc.p4,enc.p5,
				enc.p6,enc.p7,enc.p8,enc.p9,enc.mejora,enc.observacion 
				FROM biripit_stage_dw_silob.encuestas enc
		";
		$sql2 = $mysqli->prepare($consulta2);
		$sql2->bind_result($id_encuesta,$id_contacto,$codigo,$fecha,$area,$flag_muestreo,$flag_analisis,$p1,$p2,$p3,$p4,$p5,$p6,$p7,$p8,$p9,$mejora,$observacion);
		$sql2->execute();
		$sql2->store_result();
		$array = array();
		while($sql2->fetch()){
				$preguntas = array();
				$sql = $mysqli->prepare("SELECT preg.id_pregunta FROM PDW_preguntas preg WHERE preg.cod_encuesta='$codigo'");
				$sql->bind_result($id_pregunta);
				$sql->execute();
				$sql->store_result();
				$i = 0;
				array_push($preguntas,$p1,$p2,$p3,$p4,$p5,$p6,$p7,$p8,$p9);
				while($sql->fetch()){
					$valores = array();
					$valor = $preguntas[$i];
					$flag_insert = 1;
					array_push($valores,$id_encuesta,$id_pregunta,$valor,$id_contacto,$codigo,$fecha,$area,$flag_muestreo,$flag_analisis,$mejora,$observacion,$flag_insert);
					array_push($array,$valores);
					$i++;
				}
		}
		$array_final = array();
		$array_area = array("A"=>1,"H"=>2,"C"=>3);
		foreach($array as $valores){
			$valores[1] = (strcmp($valores[1],"")==0)? 'null' : $mysqli->real_escape_string($valores[1]);
			$valores[2] = (strcmp($valores[2],"")==0)? 'null' : $mysqli->real_escape_string($valores[2]);
			$valores[3] = (strcmp($valores[3],"")==0)? 'null' : $mysqli->real_escape_string($valores[3]);
			$valores[4] = (strcmp($valores[4],"")==0)? 'null' : "'".$mysqli->real_escape_string($valores[4])."'";
			$valores[5] = (strcmp($valores[5],"")==0)? 'null' : "'".$mysqli->real_escape_string($valores[5])."'";
			$valores[6] = (strcmp($valores[6],"")==0)? 'null' : $mysqli->real_escape_string($array_area[$valores[6]]);
			$valores[7] = (strcmp($valores[7],"")==0)? 'null' : $mysqli->real_escape_string($valores[7]);
			$valores[8] = (strcmp($valores[8],"")==0)? 'null' : $mysqli->real_escape_string($valores[8]);
			$valores[9] = (strcmp($valores[9],"")==0)? 'null' : "'".$mysqli->real_escape_string($valores[9])."'";
			$valores[10] = (strcmp($valores[10],"")==0)? 'null' : "'".$mysqli->real_escape_string($valores[10])."'";
			$valores[11] = (strcmp($valores[11],"")==0)? 'null' : "'".$mysqli->real_escape_string($valores[11])."'";
			$str = "(".implode(",",$valores).")";
			array_push($array_final,$str);
		}
		
		$str = implode(",",$array_final);
		$mysqli->query("SET foreign_key_checks = 0");
		$sql = $mysqli->query("INSERT INTO PDW_encuestas(id_encuesta,id_pregunta,valor_pregunta,id_contacto,codigo,fecha,area,flag_muestreo,flag_analisis,mejora,observacion,flag_insert) VALUES $str");	
	}
	function modificar_encuestas($mysqli){
		$consulta = "
			SELECT 
				res.WID_resumen_mensual_encuesta,
				GROUP_CONCAT(DISTINCT encu.WID_encuesta)
			FROM
					PDW_encuestas encu
				LEFT JOIN PDW_preguntas preg ON preg.id_pregunta = encu.id_pregunta
				LEFT JOIN PDW_fechas fch ON fch.fecha = DATE(encu.fecha)
				LEFT JOIN PDW_tipos_ingresos tin ON tin.WID_tipo_ingreso = encu.area
				LEFT JOIN PDW_resumen_mensual_encuestas res ON res.WID_mes = fch.WID_mes AND res.WID_pregunta=preg.WID_pregunta AND res.WID_area 
			WHERE
				 encu.valor_pregunta IS NOT NULL
				GROUP BY DATE_FORMAT(fch.fecha, '%Y-%m'),encu.id_pregunta,encu.area;
		";
		$sql = $mysqli->prepare(utf8_decode($consulta));
		$sql->bind_result($wid_resum,$wid_encu);
		$sql->execute();
		$sql->store_result();
		while($sql->fetch()){
			$str = "(".$wid_encu.")";
			$mysqli->query("SET foreign_key_checks = 0");
			$sql2 = $mysqli->query("UPDATE PDW_encuestas SET WID_resumen_mensual_encuesta=$wid_resum WHERE WID_encuesta IN $str");
			if(!$sql2) echo $mysqli->error;
		}
	}
	function modificar_resumen($mysqli){
		$consulta = "
			SELECT area,COUNT(DISTINCT enc.id_encuesta) FROM PDW_encuestas enc
			INNER JOIN PDW_tipos_ingresos ti ON ti.WID_tipo_ingreso=enc.area
			WHERE enc.valor_pregunta IS NOT NULL
			GROUP BY enc.area
		";
		$sql = $mysqli->prepare(utf8_decode($consulta));
		$sql->bind_result($area,$cantidad);
		$sql->execute();
		$sql->store_result();
		while($sql->fetch()){
			$mysqli->query("SET foreign_key_checks = 0");
			$sql2 = $mysqli->query("UPDATE PDW_resumen_mensual_encuestas SET enc_resp_area=$cantidad WHERE WID_area=$area");
			if(!$sql2) echo $mysqli->error;
		}
	}
?>