<?php	
	function cargar_encuestas($mysqli){
		$consulta2 = "
				SELECT enc.id_encuesta,enc.id_contacto,enc.codigo,enc.fecha,area,enc.flag_muestreo,enc.flag_analisis,enc.p1,enc.p2,enc.p3,enc.p4,enc.p5,
				enc.p6,enc.p7,enc.p8,enc.p9,enc.mejora,enc.observacion 
				FROM biripit_stage_dw_silob.encuestas enc
		";
		$sql2 = $mysqli->prepare($consulta2);
		$sql2->bind_result($id_encuesta,$id_contacto,$codigo,$fecha,$area,$flag_muestreo,$flag_analisis,$p1,$p2,$p3,$p4,$p5,$p6,$p7,$p8,$p9,$mejora,$observacion);
		$sql2->execute();
		$sql2->store_result();
		$array = array(1=>array(),2=>array());
		$array_area = array("A"=>1,"H"=>2,"C"=>3);
		while($sql2->fetch()){
				/*preguntamos si esta encuesta existe en la tabla*/
				$existe = validar_existencia($mysqli,$id_encuesta);
				$preguntas = array($p1,$p2,$p3,$p4,$p5,$p6,$p7,$p8,$p9);
				$array_wid = array();
				$area = $array_area[$area];
				switch($existe){
					case 0: 
							$informacion = array($id_encuesta,$id_contacto,$codigo,$fecha,$area,$flag_muestreo,$flag_analisis,$mejora,$observacion);
							$valores = obtener_valores($mysqli,$preguntas,$array_wid,$informacion);
							array_push($array[1],$valores);
							break;
					case 1: 
							$informacion = array($id_encuesta,$id_contacto,$codigo,$fecha,$area,$flag_muestreo,$flag_analisis,$mejora,$observacion);
							$array_wid = obtener_wid($mysqli,$id_encuesta);
							$valores = obtener_valores($mysqli,$preguntas,$array_wid,$informacion);
							array_push($array[2],$valores);
							break;
				}
		}
		update_masivo($array[2],$mysqli);
		insert_masivo($array[1],$mysqli);
	} 
	function validar_existencia($mysqli,$id_encuesta){
		$consulta = "SELECT count(DISTINCT id_encuesta) FROM PDW_encuestas WHERE id_encuesta = $id_encuesta";
		$sql = $mysqli->prepare($consulta);
		$sql->bind_result($cont);
		$sql->execute();
		$sql->store_result();
		$sql->fetch();
		
		return $cont;
	}
	function obtener_wid($mysqli,$id_encuesta){
		$array_wid = array();
		$consulta = "SELECT WID_encuesta FROM PDW_encuestas WHERE id_encuesta = $id_encuesta";
		$sql = $mysqli->prepare($consulta);
		$sql->bind_result($wid);
		$sql->execute();
		$sql->store_result();
		while($sql->fetch()){
			array_push($array_wid,$wid);
		}
		return $array_wid;
	}
	function obtener_valores($mysqli,$preguntas,$array_wid,$informacion){
		$sql = $mysqli->prepare("SELECT preg.id_pregunta FROM PDW_preguntas preg WHERE preg.cod_encuesta='".$informacion[2]."'");
		$sql->bind_result($id_pregunta);
		$sql->execute();
		$sql->store_result();
		$i = 0;
		$array = array();
		while($sql->fetch()){
			$valores = array();
			$valor = $preguntas[$i];
			array_push($valores,$informacion[0],$id_pregunta,$valor,$informacion[1],$informacion[2],$informacion[3],$informacion[4],$informacion[5],$informacion[6],$informacion[7],$informacion[8]);
			array_push($array,$valores);
			$i++;
		}
		
		$newArray = array();
		if(!empty($array_wid)){
			$k = 0;
			foreach($array as $valores){
				array_unshift($valores,$array_wid[$k]);
				array_push($newArray,$valores);
				$k++;
			}
			return $newArray;
		}
		
		return $array;
	}
	function insert_masivo($array,$mysqli){
		if(!empty($array)){
			$newArray = limpiar_valores($array,$mysqli);
			$str = implode(",",$newArray);
			$consulta = "INSERT INTO PDW_encuestas(WID_encuesta,id_encuesta,id_pregunta,valor_pregunta,id_contacto,codigo,fecha,area,flag_muestreo,flag_analisis,mejora,observacion) VALUES $str";
			$sql = $mysqli->query($consulta);
			if(!$sql) echo "encuestas insert: ".$mysqli->error;
		}
		
	}
	function update_masivo($array,$mysqli){
		if(!empty($array)){
			$newArray = limpiar_valores($array,$mysqli);
			$str = implode(",",$newArray);
			$consulta = "
					INSERT INTO PDW_encuestas(WID_encuesta,id_encuesta,id_pregunta,valor_pregunta,id_contacto,codigo,fecha,area,flag_muestreo,flag_analisis,mejora,observacion) VALUES $str
					ON DUPLICATE KEY UPDATE
					id_encuesta = VALUES(id_encuesta),
					id_pregunta = VALUES(id_pregunta),
					valor_pregunta = VALUES(valor_pregunta),
					id_contacto = VALUES(id_contacto),
					codigo = VALUES(codigo),
					fecha = VALUES(fecha),
					area = VALUES(area),
					flag_muestreo = VALUES(flag_muestreo),
					flag_analisis = VALUES(flag_analisis),
					mejora = VALUES(mejora),
					observacion = VALUES(observacion),
					flag_insert = '2'
			";
			$sql = $mysqli->query($consulta);
			if(!$sql) echo "encuestas update: ".$mysqli->error;
		}
	}
	function limpiar_valores($array,$mysqli){
		$newArray = array();
		$array_area = array("A"=>1,"H"=>2,"C"=>3);
		foreach($array as $arr){
			foreach($arr as $valores){
				$valores[1] = (strcmp($valores[1],"")==0)? 'null' : $mysqli->real_escape_string($valores[1]);
				$valores[2] = (strcmp($valores[2],"")==0)? 'null' : $mysqli->real_escape_string($valores[2]);
				$valores[3] = (strcmp($valores[3],"")==0)? 'null' : $mysqli->real_escape_string($valores[3]);
				$valores[4] = (strcmp($valores[4],"")==0)? 'null' : $mysqli->real_escape_string($valores[4]);
				$valores[5] = (strcmp($valores[5],"")==0)? 'null' : "'".$mysqli->real_escape_string($valores[5])."'";
				$valores[6] = (strcmp($valores[6],"")==0)? 'null' : "'".$mysqli->real_escape_string($valores[6])."'";
				$valores[7] = (strcmp($valores[7],"")==0)? 'null' : "'".$mysqli->real_escape_string($valores[7])."'";
				$valores[8] = (strcmp($valores[8],"")==0)? 'null' : $mysqli->real_escape_string($valores[8]);
				$valores[9] = (strcmp($valores[9],"")==0)? 'null' : $mysqli->real_escape_string($valores[9]);
				$valores[10] = (strcmp($valores[10],"")==0)? 'null' : "'".$mysqli->real_escape_string($valores[10])."'";
				$valores[11] = (strcmp($valores[11],"")==0)? 'null' : "'".$mysqli->real_escape_string($valores[11])."'";
				$str =  "(".implode(",",$valores).")";
				array_push($newArray,$str);
			}
		}
		return $newArray;
	}
?>

