<?php
	/*funciones actualizacion tabla resumen ingresos*/
	class resumen_ingresos{
		function cantidad_ingresos($mysqli){
			$consulta = utf8_decode("
				SELECT
					fch.WID_año,
					fch.WID_semestre,
					fch.WID_mes,
					count(DISTINCT ing.WID_ingreso)
				FROM
					PDW_ingresos ing
				LEFT JOIN PDW_fechas fch ON fch.fecha = DATE(ing.fecha_ingreso)
				WHERE
					DATE_FORMAT(ing.fecha_ingreso, '%Y-%m') >= '2017-01'
				AND ing.raya IS NULL
				AND ing.id_cliente != 831
				GROUP BY
					DATE_FORMAT(ing.fecha_ingreso, '%Y-%m')
			");
			$sql = $mysqli->prepare($consulta);
			if(!$sql) echo $mysqli->error;
			$sql->bind_result($wid_a,$wid_s,$wid_m,$cantidad);
			$sql->execute();
			$sql->store_result();
			WHILE($sql->fetch()){
				$sql2 = $mysqli->query("CALL updCantResumIng($cantidad,$wid_a,$wid_s,$wid_m)");
			}
			$sql->close();
		}
		function cantidad_muestras($mysqli){
			$consulta = utf8_decode("
				SELECT
					fch.WID_año,
					fch.WID_semestre,
					fch.WID_mes,
					count(DISTINCT mue.WID_muestra)
				FROM
					PDW_ingresos ing
				LEFT JOIN PDW_fechas fch ON fch.fecha = DATE(ing.fecha_ingreso)
				LEFT JOIN PDW_muestras mue ON mue.id_ingreso = ing.id_ingreso
				WHERE
					DATE_FORMAT(ing.fecha_ingreso,'%Y-%m') >= '2017-01' AND ing.raya IS NULL AND ing.id_cliente!=831
				GROUP BY
					DATE_FORMAT(ing.fecha_ingreso, '%Y-%m')
			");
			$sql = $mysqli->prepare($consulta);
			$sql->bind_result($wid_a,$wid_s,$wid_m,$cantidad);
			$sql->execute();
			$sql->store_result();
			WHILE($sql->fetch()){
				$sql2 = $mysqli->query("CALL updCantResumMue($cantidad,$wid_a,$wid_s,$wid_m)");
			}
			$sql->close();
		}
		function cantidad_analisis($mysqli){
			$consulta = utf8_decode("
				SELECT
					fch.WID_año,
					fch.WID_semestre,
					fch.WID_mes,
					count(DISTINCT ana.WID_analisis)
				FROM
					PDW_ingresos ing
				LEFT JOIN PDW_fechas fch ON fch.fecha = DATE(ing.fecha_ingreso)
				LEFT JOIN PDW_muestras mue ON mue.id_ingreso = ing.id_ingreso
				LEFT JOIN PDW_analisis ana ON ana.id_muestra = mue.id_muestra
				WHERE
					DATE_FORMAT(ing.fecha_ingreso,'%Y-%m') >= '2017-01' AND ing.raya IS NULL AND ing.id_cliente!=831
				GROUP BY
					DATE_FORMAT(ing.fecha_ingreso,'%Y-%m')
			");
			$sql = $mysqli->prepare($consulta);
			$sql->bind_result($wid_a,$wid_s,$wid_m,$cantidad);
			$sql->execute();
			$sql->store_result();
			WHILE($sql->fetch()){
				$sql2 = $mysqli->query("CALL updCantResumAna($cantidad,$wid_a,$wid_s,$wid_m)");
			}
			$sql->close();
		}
		function cantidad_informes_corregidos($mysqli){
			$consulta = utf8_decode("
				SELECT
					fch.WID_año,
					fch.WID_semestre,
					fch.WID_mes,
					count(DISTINCT ing.WID_ingreso)
				FROM
					PDW_ingresos ing
				LEFT JOIN PDW_fechas fch ON fch.fecha = DATE(ing.fecha_ingreso)
				WHERE
					DATE_FORMAT(ing.fecha_ingreso,'%Y-%m') >= '2017-01' AND ing.raya LIKE '%-1%' AND ing.id_cliente!=831
				GROUP BY
					DATE_FORMAT(ing.fecha_ingreso, '%Y-%m')");
			$sql = $mysqli->prepare($consulta);
			$sql->bind_result($wid_a,$wid_s,$wid_m,$cantidad);
			$sql->execute();
			$sql->store_result();
			WHILE($sql->fetch()){
				$sql2 = $mysqli->query("CALL updCantResumInfCorr($cantidad,$wid_a,$wid_s,$wid_m)");
			}
			$sql->close();
		}
	}
	class resumen_encuestas{
		function modificar_encuestas($mysqli){
			$consulta = "
				SELECT 
					res.WID_resumen_mensual_encuesta,
					GROUP_CONCAT(DISTINCT encu.WID_encuesta)
				FROM
						PDW_encuestas encu
					LEFT JOIN PDW_preguntas preg ON preg.id_pregunta = encu.id_pregunta
					LEFT JOIN PDW_fechas fch ON fch.fecha = DATE(encu.fecha)
					LEFT JOIN PDW_tipos_ingresos tin ON tin.WID_tipo_ingreso = encu.area
					LEFT JOIN PDW_resumen_mensual_encuestas res ON res.WID_mes = fch.WID_mes AND res.WID_pregunta=preg.WID_pregunta AND res.WID_area 
				WHERE
					 encu.valor_pregunta IS NOT NULL
					GROUP BY DATE_FORMAT(fch.fecha, '%Y-%m'),encu.id_pregunta,encu.area;
			";
			$sql = $mysqli->prepare(utf8_decode($consulta));
			$sql->bind_result($wid_resum,$wid_encu);
			$sql->execute();
			$sql->store_result();
			while($sql->fetch()){
				$str = "(".$wid_encu.")";
				$mysqli->query("SET foreign_key_checks = 0");
				$sql2 = $mysqli->query("UPDATE PDW_encuestas SET WID_resumen_mensual_encuesta=$wid_resum WHERE WID_encuesta IN $str");
				if(!$sql2) echo $mysqli->error;
			}
		}
		function modificar_resumen($mysqli){
			$consulta = "
				SELECT area,COUNT(DISTINCT enc.id_encuesta) FROM PDW_encuestas enc
				INNER JOIN PDW_tipos_ingresos ti ON ti.WID_tipo_ingreso=enc.area
				WHERE enc.valor_pregunta IS NOT NULL
				GROUP BY enc.area
			";
			$sql = $mysqli->prepare(utf8_decode($consulta));
			$sql->bind_result($area,$cantidad);
			$sql->execute();
			$sql->store_result();
			while($sql->fetch()){
				$mysqli->query("SET foreign_key_checks = 0");
				$sql2 = $mysqli->query("UPDATE PDW_resumen_mensual_encuestas SET enc_resp_area=$cantidad WHERE WID_area=$area");
				if(!$sql2) echo $mysqli->error;
			}
		}
	}
	class ultimo{
		function ultima_id($mysqli,$tabla,$wid){
			$sql2 = $mysqli->query("SELECT MAX($wid) FROM $tabla");
			$fila = $sql2->fetch_row();
			return $fila[0];
		}
	}
?>